/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.tar;

import java.io.IOException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import org.apache.commons.compress.archivers.zip.ZipEncoding;
import org.apache.commons.compress.archivers.zip.ZipEncodingHelper;

public class TarUtils {
    private static final int BYTE_MASK = 255;
    static final ZipEncoding DEFAULT_ENCODING = ZipEncodingHelper.getZipEncoding(null);
    static final ZipEncoding FALLBACK_ENCODING = new ZipEncoding(){

        public boolean canEncode(String name) {
            return true;
        }

        public ByteBuffer encode(String name) {
            int length2 = name.length();
            byte[] buf = new byte[length2];
            for (int i = 0; i < length2; ++i) {
                buf[i] = (byte)name.charAt(i);
            }
            return ByteBuffer.wrap(buf);
        }

        public String decode(byte[] buffer) {
            byte b;
            int length2 = buffer.length;
            StringBuffer result = new StringBuffer(length2);
            for (int i = 0; i < length2 && (b = buffer[i]) != 0; ++i) {
                result.append((char)(b & 0xFF));
            }
            return result.toString();
        }
    };

    private TarUtils() {
    }

    public static long parseOctal(byte[] buffer, int offset, int length2) {
        int start;
        long result = 0L;
        int end = offset + length2;
        if (length2 < 2) {
            throw new IllegalArgumentException("Length " + length2 + " must be at least 2");
        }
        if (buffer[start] == 0) {
            return 0L;
        }
        for (start = offset; start < end && buffer[start] == 32; ++start) {
        }
        byte trailer = buffer[end - 1];
        if (trailer != 0 && trailer != 32) {
            throw new IllegalArgumentException(TarUtils.exceptionMessage(buffer, offset, length2, end - 1, trailer));
        }
        trailer = buffer[--end - 1];
        if (trailer == 0 || trailer == 32) {
            --end;
        }
        while (start < end) {
            byte currentByte = buffer[start];
            if (currentByte < 48 || currentByte > 55) {
                throw new IllegalArgumentException(TarUtils.exceptionMessage(buffer, offset, length2, start, currentByte));
            }
            result = (result << 3) + (long)(currentByte - 48);
            ++start;
        }
        return result;
    }

    public static long parseOctalOrBinary(byte[] buffer, int offset, int length2) {
        boolean negative;
        if ((buffer[offset] & 0x80) == 0) {
            return TarUtils.parseOctal(buffer, offset, length2);
        }
        boolean bl = negative = buffer[offset] == -1;
        if (length2 < 9) {
            return TarUtils.parseBinaryLong(buffer, offset, length2, negative);
        }
        return TarUtils.parseBinaryBigInteger(buffer, offset, length2, negative);
    }

    private static long parseBinaryLong(byte[] buffer, int offset, int length2, boolean negative) {
        if (length2 >= 9) {
            throw new IllegalArgumentException("At offset " + offset + ", " + length2 + " byte binary number" + " exceeds maximum signed long" + " value");
        }
        long val = 0L;
        for (int i = 1; i < length2; ++i) {
            val = (val << 8) + (long)(buffer[offset + i] & 0xFF);
        }
        if (negative) {
            --val;
            val ^= (long)Math.pow(2.0, (length2 - 1) * 8) - 1L;
        }
        return negative ? -val : val;
    }

    private static long parseBinaryBigInteger(byte[] buffer, int offset, int length2, boolean negative) {
        byte[] remainder = new byte[length2 - 1];
        System.arraycopy(buffer, offset + 1, remainder, 0, length2 - 1);
        BigInteger val = new BigInteger(remainder);
        if (negative) {
            val = val.add(BigInteger.valueOf(-1L)).not();
        }
        if (val.bitLength() > 63) {
            throw new IllegalArgumentException("At offset " + offset + ", " + length2 + " byte binary number" + " exceeds maximum signed long" + " value");
        }
        return negative ? -val.longValue() : val.longValue();
    }

    public static boolean parseBoolean(byte[] buffer, int offset) {
        return buffer[offset] == 1;
    }

    private static String exceptionMessage(byte[] buffer, int offset, int length2, int current, byte currentByte) {
        String string = new String(buffer, offset, length2);
        string = string.replaceAll("\u0000", "{NUL}");
        String s = "Invalid byte " + currentByte + " at offset " + (current - offset) + " in '" + string + "' len=" + length2;
        return s;
    }

    public static String parseName(byte[] buffer, int offset, int length2) {
        try {
            return TarUtils.parseName(buffer, offset, length2, DEFAULT_ENCODING);
        }
        catch (IOException ex) {
            try {
                return TarUtils.parseName(buffer, offset, length2, FALLBACK_ENCODING);
            }
            catch (IOException ex2) {
                throw new RuntimeException(ex2);
            }
        }
    }

    public static String parseName(byte[] buffer, int offset, int length2, ZipEncoding encoding) throws IOException {
        int len;
        for (len = length2; len > 0 && buffer[offset + len - 1] == 0; --len) {
        }
        if (len > 0) {
            byte[] b = new byte[len];
            System.arraycopy(buffer, offset, b, 0, len);
            return encoding.decode(b);
        }
        return "";
    }

    public static int formatNameBytes(String name, byte[] buf, int offset, int length2) {
        try {
            return TarUtils.formatNameBytes(name, buf, offset, length2, DEFAULT_ENCODING);
        }
        catch (IOException ex) {
            try {
                return TarUtils.formatNameBytes(name, buf, offset, length2, FALLBACK_ENCODING);
            }
            catch (IOException ex2) {
                throw new RuntimeException(ex2);
            }
        }
    }

    public static int formatNameBytes(String name, byte[] buf, int offset, int length2, ZipEncoding encoding) throws IOException {
        int len = name.length();
        ByteBuffer b = encoding.encode(name);
        while (b.limit() > length2 && len > 0) {
            b = encoding.encode(name.substring(0, --len));
        }
        int limit = b.limit();
        System.arraycopy(b.array(), b.arrayOffset(), buf, offset, limit);
        for (int i = limit; i < length2; ++i) {
            buf[offset + i] = 0;
        }
        return offset + length2;
    }

    public static void formatUnsignedOctalString(long value, byte[] buffer, int offset, int length2) {
        int remaining = length2;
        --remaining;
        if (value == 0L) {
            buffer[offset + remaining--] = 48;
        } else {
            long val;
            for (val = value; remaining >= 0 && val != 0L; val >>>= 3, --remaining) {
                buffer[offset + remaining] = (byte)(48 + (byte)(val & 7L));
            }
            if (val != 0L) {
                throw new IllegalArgumentException(value + "=" + Long.toOctalString(value) + " will not fit in octal number buffer of length " + length2);
            }
        }
        while (remaining >= 0) {
            buffer[offset + remaining] = 48;
            --remaining;
        }
    }

    public static int formatOctalBytes(long value, byte[] buf, int offset, int length2) {
        int idx = length2 - 2;
        TarUtils.formatUnsignedOctalString(value, buf, offset, idx);
        buf[offset + idx++] = 32;
        buf[offset + idx] = 0;
        return offset + length2;
    }

    public static int formatLongOctalBytes(long value, byte[] buf, int offset, int length2) {
        int idx = length2 - 1;
        TarUtils.formatUnsignedOctalString(value, buf, offset, idx);
        buf[offset + idx] = 32;
        return offset + length2;
    }

    public static int formatLongOctalOrBinaryBytes(long value, byte[] buf, int offset, int length2) {
        boolean negative;
        long maxAsOctalChar = length2 == 8 ? 0x1FFFFFL : 0x1FFFFFFFFL;
        boolean bl = negative = value < 0L;
        if (!negative && value <= maxAsOctalChar) {
            return TarUtils.formatLongOctalBytes(value, buf, offset, length2);
        }
        if (length2 < 9) {
            TarUtils.formatLongBinary(value, buf, offset, length2, negative);
        }
        TarUtils.formatBigIntegerBinary(value, buf, offset, length2, negative);
        buf[offset] = (byte)(negative ? 255 : 128);
        return offset + length2;
    }

    private static void formatLongBinary(long value, byte[] buf, int offset, int length2, boolean negative) {
        int bits = (length2 - 1) * 8;
        long max2 = 1L << bits;
        long val = Math.abs(value);
        if (val >= max2) {
            throw new IllegalArgumentException("Value " + value + " is too large for " + length2 + " byte field.");
        }
        if (negative) {
            val ^= max2 - 1L;
            val |= (long)(255 << bits);
            ++val;
        }
        for (int i = offset + length2 - 1; i >= offset; --i) {
            buf[i] = (byte)val;
            val >>= 8;
        }
    }

    private static void formatBigIntegerBinary(long value, byte[] buf, int offset, int length2, boolean negative) {
        BigInteger val = BigInteger.valueOf(value);
        byte[] b = val.toByteArray();
        int len = b.length;
        int off = offset + length2 - len;
        System.arraycopy(b, 0, buf, off, len);
        byte fill = (byte)(negative ? 255 : 0);
        for (int i = offset + 1; i < off; ++i) {
            buf[i] = fill;
        }
    }

    public static int formatCheckSumOctalBytes(long value, byte[] buf, int offset, int length2) {
        int idx = length2 - 2;
        TarUtils.formatUnsignedOctalString(value, buf, offset, idx);
        buf[offset + idx++] = 0;
        buf[offset + idx] = 32;
        return offset + length2;
    }

    public static long computeCheckSum(byte[] buf) {
        long sum2 = 0L;
        for (int i = 0; i < buf.length; ++i) {
            sum2 += (long)(0xFF & buf[i]);
        }
        return sum2;
    }
}

