/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.linear;

import java.lang.reflect.Array;
import org.apache.commons.math.Field;
import org.apache.commons.math.FieldElement;
import org.apache.commons.math.MathRuntimeException;
import org.apache.commons.math.exception.util.LocalizedFormats;
import org.apache.commons.math.linear.Array2DRowFieldMatrix;
import org.apache.commons.math.linear.ArrayFieldVector;
import org.apache.commons.math.linear.FieldDecompositionSolver;
import org.apache.commons.math.linear.FieldLUDecomposition;
import org.apache.commons.math.linear.FieldMatrix;
import org.apache.commons.math.linear.FieldVector;
import org.apache.commons.math.linear.InvalidMatrixException;
import org.apache.commons.math.linear.NonSquareMatrixException;
import org.apache.commons.math.linear.SingularMatrixException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldLUDecompositionImpl<T extends FieldElement<T>>
implements FieldLUDecomposition<T> {
    private final Field<T> field;
    private T[][] lu;
    private int[] pivot;
    private boolean even;
    private boolean singular;
    private FieldMatrix<T> cachedL;
    private FieldMatrix<T> cachedU;
    private FieldMatrix<T> cachedP;

    public FieldLUDecompositionImpl(FieldMatrix<T> matrix2) throws NonSquareMatrixException {
        if (!matrix2.isSquare()) {
            throw new NonSquareMatrixException(matrix2.getRowDimension(), matrix2.getColumnDimension());
        }
        int m = matrix2.getColumnDimension();
        this.field = matrix2.getField();
        this.lu = matrix2.getData();
        this.pivot = new int[m];
        this.cachedL = null;
        this.cachedU = null;
        this.cachedP = null;
        for (int row2 = 0; row2 < m; ++row2) {
            this.pivot[row2] = row2;
        }
        this.even = true;
        this.singular = false;
        for (int col2 = 0; col2 < m; ++col2) {
            FieldElement<T> sum2 = (FieldElement)this.field.getZero();
            for (int row3 = 0; row3 < col2; ++row3) {
                T[] luRow = this.lu[row3];
                sum2 = luRow[col2];
                for (int i = 0; i < row3; ++i) {
                    sum2 = (FieldElement)sum2.subtract(luRow[i].multiply(this.lu[i][col2]));
                }
                luRow[col2] = sum2;
            }
            int nonZero = col2;
            for (int row4 = col2; row4 < m; ++row4) {
                T[] luRow = this.lu[row4];
                sum2 = luRow[col2];
                for (int i = 0; i < col2; ++i) {
                    sum2 = (FieldElement)sum2.subtract(luRow[i].multiply(this.lu[i][col2]));
                }
                luRow[col2] = sum2;
                if (!this.lu[nonZero][col2].equals(this.field.getZero())) continue;
                ++nonZero;
            }
            if (nonZero >= m) {
                this.singular = true;
                return;
            }
            if (nonZero != col2) {
                FieldElement tmp = (FieldElement)this.field.getZero();
                for (int i = 0; i < m; ++i) {
                    tmp = this.lu[nonZero][i];
                    this.lu[nonZero][i] = this.lu[col2][i];
                    this.lu[col2][i] = tmp;
                }
                int temp = this.pivot[nonZero];
                this.pivot[nonZero] = this.pivot[col2];
                this.pivot[col2] = temp;
                this.even = !this.even;
            }
            T luDiag = this.lu[col2][col2];
            for (int row5 = col2 + 1; row5 < m; ++row5) {
                T[] luRow = this.lu[row5];
                luRow[col2] = (FieldElement)luRow[col2].divide(luDiag);
            }
        }
    }

    @Override
    public FieldMatrix<T> getL() {
        if (this.cachedL == null && !this.singular) {
            int m = this.pivot.length;
            this.cachedL = new Array2DRowFieldMatrix<T>(this.field, m, m);
            for (int i = 0; i < m; ++i) {
                T[] luI = this.lu[i];
                for (int j = 0; j < i; ++j) {
                    this.cachedL.setEntry(i, j, luI[j]);
                }
                this.cachedL.setEntry(i, i, (FieldElement)this.field.getOne());
            }
        }
        return this.cachedL;
    }

    @Override
    public FieldMatrix<T> getU() {
        if (this.cachedU == null && !this.singular) {
            int m = this.pivot.length;
            this.cachedU = new Array2DRowFieldMatrix<T>(this.field, m, m);
            for (int i = 0; i < m; ++i) {
                T[] luI = this.lu[i];
                for (int j = i; j < m; ++j) {
                    this.cachedU.setEntry(i, j, luI[j]);
                }
            }
        }
        return this.cachedU;
    }

    @Override
    public FieldMatrix<T> getP() {
        if (this.cachedP == null && !this.singular) {
            int m = this.pivot.length;
            this.cachedP = new Array2DRowFieldMatrix<T>(this.field, m, m);
            for (int i = 0; i < m; ++i) {
                this.cachedP.setEntry(i, this.pivot[i], (FieldElement)this.field.getOne());
            }
        }
        return this.cachedP;
    }

    @Override
    public int[] getPivot() {
        return (int[])this.pivot.clone();
    }

    @Override
    public T getDeterminant() {
        if (this.singular) {
            return (T)((FieldElement)this.field.getZero());
        }
        int m = this.pivot.length;
        FieldElement determinant = this.even ? (FieldElement)this.field.getOne() : (FieldElement)((FieldElement)this.field.getZero()).subtract(this.field.getOne());
        for (int i = 0; i < m; ++i) {
            determinant = (FieldElement)determinant.multiply(this.lu[i][i]);
        }
        return (T)determinant;
    }

    @Override
    public FieldDecompositionSolver<T> getSolver() {
        return new Solver(this.field, (FieldElement[][])this.lu, this.pivot, this.singular);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Solver<T extends FieldElement<T>>
    implements FieldDecompositionSolver<T> {
        private static final long serialVersionUID = -6353105415121373022L;
        private final Field<T> field;
        private final T[][] lu;
        private final int[] pivot;
        private final boolean singular;

        private Solver(Field<T> field, T[][] lu, int[] pivot, boolean singular) {
            this.field = field;
            this.lu = lu;
            this.pivot = pivot;
            this.singular = singular;
        }

        @Override
        public boolean isNonSingular() {
            return !this.singular;
        }

        @Override
        public T[] solve(T[] b) throws IllegalArgumentException, InvalidMatrixException {
            int i;
            FieldElement bpCol;
            int col2;
            int m = this.pivot.length;
            if (b.length != m) {
                throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.VECTOR_LENGTH_MISMATCH, b.length, m);
            }
            if (this.singular) {
                throw new SingularMatrixException();
            }
            FieldElement[] bp = (FieldElement[])Array.newInstance(((FieldElement)this.field.getZero()).getClass(), m);
            for (int row2 = 0; row2 < m; ++row2) {
                bp[row2] = b[this.pivot[row2]];
            }
            for (col2 = 0; col2 < m; ++col2) {
                bpCol = bp[col2];
                for (i = col2 + 1; i < m; ++i) {
                    bp[i] = (FieldElement)bp[i].subtract(bpCol.multiply(this.lu[i][col2]));
                }
            }
            for (col2 = m - 1; col2 >= 0; --col2) {
                bp[col2] = (FieldElement)bp[col2].divide(this.lu[col2][col2]);
                bpCol = bp[col2];
                for (i = 0; i < col2; ++i) {
                    bp[i] = (FieldElement)bp[i].subtract(bpCol.multiply(this.lu[i][col2]));
                }
            }
            return bp;
        }

        @Override
        public FieldVector<T> solve(FieldVector<T> b) throws IllegalArgumentException, InvalidMatrixException {
            try {
                return this.solve((ArrayFieldVector)b);
            }
            catch (ClassCastException cce) {
                int i;
                FieldElement bpCol;
                int col2;
                int m = this.pivot.length;
                if (b.getDimension() != m) {
                    throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.VECTOR_LENGTH_MISMATCH, b.getDimension(), m);
                }
                if (this.singular) {
                    throw new SingularMatrixException();
                }
                FieldElement[] bp = (FieldElement[])Array.newInstance(((FieldElement)this.field.getZero()).getClass(), m);
                for (int row2 = 0; row2 < m; ++row2) {
                    bp[row2] = b.getEntry(this.pivot[row2]);
                }
                for (col2 = 0; col2 < m; ++col2) {
                    bpCol = bp[col2];
                    for (i = col2 + 1; i < m; ++i) {
                        bp[i] = (FieldElement)bp[i].subtract(bpCol.multiply(this.lu[i][col2]));
                    }
                }
                for (col2 = m - 1; col2 >= 0; --col2) {
                    bp[col2] = (FieldElement)bp[col2].divide(this.lu[col2][col2]);
                    bpCol = bp[col2];
                    for (i = 0; i < col2; ++i) {
                        bp[i] = (FieldElement)bp[i].subtract(bpCol.multiply(this.lu[i][col2]));
                    }
                }
                return new ArrayFieldVector(bp, false);
            }
        }

        @Override
        public ArrayFieldVector<T> solve(ArrayFieldVector<T> b) throws IllegalArgumentException, InvalidMatrixException {
            return new ArrayFieldVector(this.solve(b.getDataRef()), false);
        }

        @Override
        public FieldMatrix<T> solve(FieldMatrix<T> b) throws IllegalArgumentException, InvalidMatrixException {
            FieldElement[] bpCol;
            int col2;
            int m = this.pivot.length;
            if (b.getRowDimension() != m) {
                throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.DIMENSIONS_MISMATCH_2x2, b.getRowDimension(), b.getColumnDimension(), m, "n");
            }
            if (this.singular) {
                throw new SingularMatrixException();
            }
            int nColB = b.getColumnDimension();
            FieldElement[][] bp = (FieldElement[][])Array.newInstance(((FieldElement)this.field.getZero()).getClass(), m, nColB);
            for (int row2 = 0; row2 < m; ++row2) {
                FieldElement[] bpRow = bp[row2];
                int pRow = this.pivot[row2];
                for (int col3 = 0; col3 < nColB; ++col3) {
                    bpRow[col3] = b.getEntry(pRow, col3);
                }
            }
            for (col2 = 0; col2 < m; ++col2) {
                bpCol = bp[col2];
                for (int i = col2 + 1; i < m; ++i) {
                    FieldElement[] bpI = bp[i];
                    T luICol = this.lu[i][col2];
                    for (int j = 0; j < nColB; ++j) {
                        bpI[j] = (FieldElement)bpI[j].subtract(bpCol[j].multiply(luICol));
                    }
                }
            }
            for (col2 = m - 1; col2 >= 0; --col2) {
                bpCol = bp[col2];
                T luDiag = this.lu[col2][col2];
                for (int j = 0; j < nColB; ++j) {
                    bpCol[j] = (FieldElement)bpCol[j].divide(luDiag);
                }
                for (int i = 0; i < col2; ++i) {
                    FieldElement[] bpI = bp[i];
                    T luICol = this.lu[i][col2];
                    for (int j = 0; j < nColB; ++j) {
                        bpI[j] = (FieldElement)bpI[j].subtract(bpCol[j].multiply(luICol));
                    }
                }
            }
            return new Array2DRowFieldMatrix(bp, false);
        }

        @Override
        public FieldMatrix<T> getInverse() throws InvalidMatrixException {
            int m = this.pivot.length;
            FieldElement one = (FieldElement)this.field.getOne();
            Array2DRowFieldMatrix<FieldElement> identity = new Array2DRowFieldMatrix<FieldElement>(this.field, m, m);
            for (int i = 0; i < m; ++i) {
                identity.setEntry(i, i, one);
            }
            return this.solve(identity);
        }
    }
}

