/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.impl;

import java.io.IOException;
import java.net.URL;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.SecureClassLoader;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.jar.Attributes;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.NameScope;
import org.apache.commons.vfs2.impl.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VFSClassLoader
extends SecureClassLoader {
    private final ArrayList<FileObject> resources = new ArrayList();

    public VFSClassLoader(FileObject file2, FileSystemManager manager) throws FileSystemException {
        this(new FileObject[]{file2}, manager, null);
    }

    public VFSClassLoader(FileObject file2, FileSystemManager manager, ClassLoader parent2) throws FileSystemException {
        this(new FileObject[]{file2}, manager, parent2);
    }

    public VFSClassLoader(FileObject[] files2, FileSystemManager manager) throws FileSystemException {
        this(files2, manager, null);
    }

    public VFSClassLoader(FileObject[] files2, FileSystemManager manager, ClassLoader parent2) throws FileSystemException {
        super(parent2);
        this.addFileObjects(manager, files2);
    }

    public FileObject[] getFileObjects() {
        return this.resources.toArray(new FileObject[this.resources.size()]);
    }

    private void addFileObjects(FileSystemManager manager, FileObject[] files2) throws FileSystemException {
        for (int i = 0; i < files2.length; ++i) {
            FileObject file2 = files2[i];
            if (!file2.exists()) continue;
            if (manager.canCreateFileSystem(file2)) {
                file2 = manager.createFileSystem(file2);
            }
            this.resources.add(file2);
        }
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        try {
            String path2 = name.replace('.', '/').concat(".class");
            Resource res = this.loadResource(path2);
            if (res == null) {
                throw new ClassNotFoundException(name);
            }
            return this.defineClass(name, res);
        }
        catch (IOException ioe) {
            throw new ClassNotFoundException(name, ioe);
        }
    }

    private Class<?> defineClass(String name, Resource res) throws IOException {
        URL url2 = res.getCodeSourceURL();
        String pkgName = res.getPackageName();
        if (pkgName != null) {
            Package pkg = this.getPackage(pkgName);
            if (pkg != null) {
                if (pkg.isSealed()) {
                    if (!pkg.isSealed(url2)) {
                        throw new FileSystemException("vfs.impl/pkg-sealed-other-url", pkgName);
                    }
                } else if (this.isSealed(res)) {
                    throw new FileSystemException("vfs.impl/pkg-sealing-unsealed", pkgName);
                }
            } else {
                this.definePackage(pkgName, res);
            }
        }
        byte[] bytes = res.getBytes();
        Certificate[] certs = res.getFileObject().getContent().getCertificates();
        CodeSource cs = new CodeSource(url2, certs);
        return this.defineClass(name, bytes, 0, bytes.length, cs);
    }

    private boolean isSealed(Resource res) throws FileSystemException {
        String sealed = res.getPackageAttribute(Attributes.Name.SEALED);
        return "true".equalsIgnoreCase(sealed);
    }

    private Package definePackage(String name, Resource res) throws FileSystemException {
        String specTitle = res.getPackageAttribute(Attributes.Name.SPECIFICATION_TITLE);
        String specVendor = res.getPackageAttribute(Attributes.Name.SPECIFICATION_VENDOR);
        String specVersion = res.getPackageAttribute(Attributes.Name.SPECIFICATION_VERSION);
        String implTitle = res.getPackageAttribute(Attributes.Name.IMPLEMENTATION_TITLE);
        String implVendor = res.getPackageAttribute(Attributes.Name.IMPLEMENTATION_VENDOR);
        String implVersion = res.getPackageAttribute(Attributes.Name.IMPLEMENTATION_VERSION);
        URL sealBase = this.isSealed(res) ? res.getCodeSourceURL() : null;
        return this.definePackage(name, specTitle, specVersion, specVendor, implTitle, implVersion, implVendor, sealBase);
    }

    @Override
    protected PermissionCollection getPermissions(CodeSource cs) {
        try {
            String url2 = cs.getLocation().toString();
            FileObject file2 = this.lookupFileObject(url2);
            if (file2 == null) {
                return super.getPermissions(cs);
            }
            FileObject parentLayer = file2.getFileSystem().getParentLayer();
            if (parentLayer == null) {
                return super.getPermissions(cs);
            }
            Permissions combi = new Permissions();
            PermissionCollection permCollect = super.getPermissions(cs);
            this.copyPermissions(permCollect, combi);
            FileObject parent2 = parentLayer;
            while (parent2 != null) {
                CodeSource parentcs = new CodeSource(parent2.getURL(), parent2.getContent().getCertificates());
                permCollect = super.getPermissions(parentcs);
                this.copyPermissions(permCollect, combi);
                parent2 = parent2.getFileSystem().getParentLayer();
            }
            return combi;
        }
        catch (FileSystemException fse) {
            throw new SecurityException(fse.getMessage());
        }
    }

    protected void copyPermissions(PermissionCollection src, PermissionCollection dest) {
        Enumeration<Permission> elem = src.elements();
        while (elem.hasMoreElements()) {
            Permission permission = elem.nextElement();
            dest.add(permission);
        }
    }

    private FileObject lookupFileObject(String name) {
        for (FileObject object2 : this.resources) {
            if (!name.equals(object2.getName().getURI())) continue;
            return object2;
        }
        return null;
    }

    @Override
    protected URL findResource(String name) {
        try {
            Resource res = this.loadResource(name);
            if (res != null) {
                return res.getURL();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    @Override
    protected Enumeration<URL> findResources(String name) {
        return new Enumeration<URL>(){

            @Override
            public boolean hasMoreElements() {
                return false;
            }

            @Override
            public URL nextElement() {
                return null;
            }
        };
    }

    private Resource loadResource(String name) throws FileSystemException {
        for (FileObject baseFile : this.resources) {
            FileObject file2 = baseFile.resolveFile(name, NameScope.DESCENDENT_OR_SELF);
            if (!file2.exists()) continue;
            return new Resource(name, baseFile, file2);
        }
        return null;
    }
}

