/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.tasks;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Date;
import org.apache.commons.vfs2.FileContent;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.tasks.VfsTask;
import org.apache.tools.ant.BuildException;

public class ShowFileTask
extends VfsTask {
    private static final String INDENT = "  ";
    private String url;
    private boolean showContent;
    private boolean recursive;

    public void setFile(String url2) {
        this.url = url2;
    }

    public void setShowContent(boolean showContent) {
        this.showContent = showContent;
    }

    public void setRecursive(boolean recursive2) {
        this.recursive = recursive2;
    }

    public void execute() throws BuildException {
        try {
            FileObject file2 = this.resolveFile(this.url);
            this.log("Details of " + file2.getName().getURI());
            this.showFile(file2, INDENT);
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }

    private void showFile(FileObject file2, String prefix) throws Exception {
        StringBuilder msg = new StringBuilder(prefix);
        msg.append(file2.getName().getBaseName());
        if (file2.exists()) {
            msg.append(" (");
            msg.append(file2.getType().getName());
            msg.append(")");
        } else {
            msg.append(" (unknown)");
        }
        this.log(msg.toString());
        if (file2.exists()) {
            String newPrefix = prefix + INDENT;
            if (file2.getType().hasContent()) {
                FileContent content = file2.getContent();
                this.log(newPrefix + "Content-Length: " + content.getSize());
                this.log(newPrefix + "Last-Modified" + new Date(content.getLastModifiedTime()));
                if (this.showContent) {
                    this.log(newPrefix + "Content:");
                    this.logContent(file2, newPrefix);
                }
            }
            if (file2.getType().hasChildren()) {
                FileObject[] children = file2.getChildren();
                for (int i = 0; i < children.length; ++i) {
                    FileObject child = children[i];
                    if (this.recursive) {
                        this.showFile(child, newPrefix);
                        continue;
                    }
                    this.log(newPrefix + child.getName().getBaseName());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logContent(FileObject file2, String prefix) throws Exception {
        InputStream instr = file2.getContent().getInputStream();
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(instr));
            while ((line = reader.readLine()) != null) {
                this.log(prefix + line);
            }
        }
        finally {
            instr.close();
        }
    }
}

