/*
 * Decompiled with CFR 0.152.
 */
package org.j_paine.formatter;

import java.io.StringBufferInputStream;
import org.j_paine.formatter.FormatIOElement;
import org.j_paine.formatter.FormatInputList;
import org.j_paine.formatter.IllegalObjectOnWriteException;
import org.j_paine.formatter.InputStreamAndBuffer;
import org.j_paine.formatter.InvalidNumberOnReadException;
import org.j_paine.formatter.NumberParser;
import org.j_paine.formatter.NumberTooWideOnWriteException;
import org.j_paine.formatter.ParseException;
import org.j_paine.formatter.Parsers;
import org.j_paine.formatter.TokenMgrError;

class FormatL
extends FormatIOElement {
    public FormatL(int n) {
        this.setWidth(n);
    }

    String convertToString(Object object2, int n) throws IllegalObjectOnWriteException, NumberTooWideOnWriteException {
        if (object2 instanceof Boolean) {
            char[] cArray = new char[this.getWidth()];
            for (int i = 0; i < cArray.length - 1; ++i) {
                cArray[i] = 32;
            }
            cArray[i] = (Boolean)object2 == true ? 84 : 70;
            String string = new String(cArray);
            if (string.length() > this.getWidth()) {
                throw new NumberTooWideOnWriteException((Number)object2, n, this.toString());
            }
            return string;
        }
        throw new IllegalObjectOnWriteException(object2, n, this.toString());
    }

    Object convertFromString(String string, FormatInputList formatInputList, InputStreamAndBuffer inputStreamAndBuffer) throws InvalidNumberOnReadException {
        NumberParser numberParser = Parsers.theParsers().number_parser;
        numberParser.ReInit(new StringBufferInputStream(string));
        try {
            Boolean bl;
            int n = numberParser.Boolean();
            char c2 = string.substring(n).charAt(0);
            if (c2 == 't' || c2 == 'T') {
                bl = new Boolean(true);
            } else if (c2 == 'f' || c2 == 'F') {
                bl = new Boolean(false);
            } else {
                throw new ParseException("bad logical value");
            }
            return bl;
        }
        catch (ParseException parseException) {
            throw new InvalidNumberOnReadException(string, formatInputList.getPtr(), this.toString(), inputStreamAndBuffer.getLineErrorReport(), parseException.getMessage());
        }
        catch (TokenMgrError tokenMgrError) {
            throw new InvalidNumberOnReadException(string, formatInputList.getPtr(), this.toString(), inputStreamAndBuffer.getLineErrorReport(), tokenMgrError.getMessage());
        }
    }

    public String toString() {
        return "L" + this.getWidth();
    }
}

