/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.base;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import org.renjin.eval.Context;
import org.renjin.eval.Session;
import org.renjin.eval.SessionBuilder;
import org.renjin.packaging.LazyLoadFrameBuilder;
import org.renjin.parser.RParser;
import org.renjin.repackaged.guava.base.Predicate;
import org.renjin.repackaged.guava.collect.Lists;
import org.renjin.sexp.Environment;
import org.renjin.sexp.ExpressionVector;
import org.renjin.sexp.FunctionCall;
import org.renjin.sexp.NamedValue;
import org.renjin.sexp.PrimitiveFunction;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.Symbol;

public class BasePackageCompiler {
    public static void main(String[] args2) throws IOException {
        Session session = new SessionBuilder().withoutBasePackage().build();
        Context context = session.getTopLevelContext();
        Environment baseNamespaceEnv = context.getNamespaceRegistry().getBase().getNamespaceEnvironment();
        Context evalContext = context.beginEvalContext(baseNamespaceEnv);
        File baseSourceRoot = new File("src/main/R/base");
        BasePackageCompiler.evalSources(evalContext, baseSourceRoot);
        evalContext.evaluate(FunctionCall.newCall(Symbol.get(".onLoad"), new SEXP[0]));
        final ArrayList<String> omit = Lists.newArrayList(".Last.value", ".AutoloadEnv", ".BaseNamespaceEnv", ".Device", ".Devices", ".Machine", ".Options", ".Platform");
        new LazyLoadFrameBuilder(context).outputTo(new File("target/classes/org/renjin/base")).filter(new Predicate<NamedValue>(){

            @Override
            public boolean apply(NamedValue namedValue) {
                if (omit.contains(namedValue.getName())) {
                    return false;
                }
                return !(namedValue.getValue() instanceof PrimitiveFunction);
            }
        }).build(baseNamespaceEnv);
    }

    private static void evalSources(Context evalContext, File dir2) throws IOException {
        ArrayList<File> sources = Lists.newArrayList();
        for (File sourceFile : dir2.listFiles()) {
            if (!sourceFile.getName().endsWith(".R")) continue;
            sources.add(sourceFile);
        }
        Collections.sort(sources);
        for (File source : sources) {
            try (FileReader reader = new FileReader(source);){
                ExpressionVector expr = RParser.parseAllSource(reader);
                evalContext.evaluate(expr);
            }
        }
    }
}

