/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.compiler.builtins;

import java.util.Collections;
import java.util.List;
import org.renjin.compiler.builtins.DataParallelCall;
import org.renjin.compiler.builtins.GenericPrimitive;
import org.renjin.compiler.builtins.Specialization;
import org.renjin.compiler.builtins.Specializer;
import org.renjin.compiler.builtins.StaticMethodCall;
import org.renjin.compiler.builtins.UnspecializedCall;
import org.renjin.compiler.ir.TypeSet;
import org.renjin.compiler.ir.ValueBounds;
import org.renjin.compiler.ir.tac.RuntimeState;
import org.renjin.invoke.codegen.OverloadComparator;
import org.renjin.invoke.model.JvmMethod;
import org.renjin.primitives.Primitives;
import org.renjin.sexp.AtomicVector;
import org.renjin.sexp.Null;

public class BuiltinSpecializer
implements Specializer {
    private final Primitives.Entry primitive;
    private final List<JvmMethod> methods;

    public BuiltinSpecializer(Primitives.Entry primitive2) {
        this.primitive = primitive2;
        this.methods = JvmMethod.findOverloads(this.primitive.functionClass, this.primitive.name, this.primitive.methodName);
        Collections.sort(this.methods, new OverloadComparator());
    }

    @Override
    public Specialization trySpecialize(RuntimeState runtimeState, List<ValueBounds> argumentTypes) {
        ValueBounds object2;
        Specialization genericMethod;
        JvmMethod method = this.selectOverload(argumentTypes);
        if (method == null) {
            return UnspecializedCall.INSTANCE;
        }
        if (method.isGeneric() && (genericMethod = this.maybeSpecializeToGenericCall(object2 = argumentTypes.get(0))) != null) {
            return genericMethod;
        }
        if (method.isDataParallel()) {
            return new DataParallelCall(this.primitive, method, argumentTypes).specializeFurther();
        }
        return new StaticMethodCall(method).furtherSpecialize(argumentTypes);
    }

    private Specialization maybeSpecializeToGenericCall(ValueBounds object2) {
        if (!object2.isClassAttributeConstant()) {
            return GenericPrimitive.INSTANCE;
        }
        AtomicVector classVector = object2.getConstantClassAttribute();
        if (classVector == Null.INSTANCE) {
            return null;
        }
        return GenericPrimitive.INSTANCE;
    }

    private JvmMethod selectOverload(List<ValueBounds> argumentTypes) {
        for (JvmMethod method : this.methods) {
            if (!this.matches(method, argumentTypes)) continue;
            return method;
        }
        return null;
    }

    private boolean matches(JvmMethod method, List<ValueBounds> argumentTypes) {
        if (!this.arityMatches(method, argumentTypes)) {
            return false;
        }
        for (int i = 0; i < method.getPositionalFormals().size(); ++i) {
            JvmMethod.Argument formal = method.getPositionalFormals().get(i);
            ValueBounds actualType = argumentTypes.get(i);
            if (TypeSet.matches(formal.getClazz(), actualType.getTypeSet())) continue;
            return false;
        }
        return true;
    }

    private boolean arityMatches(JvmMethod method, List<ValueBounds> argumentTypes) {
        int numPosArgs = method.getPositionalFormals().size();
        return argumentTypes.size() == numPosArgs || method.acceptsArgumentList() && argumentTypes.size() >= numPosArgs;
    }
}

