/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.compiler.cfg;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.renjin.compiler.cfg.BasicBlock;
import org.renjin.compiler.ir.tac.IRBody;
import org.renjin.compiler.ir.tac.IRLabel;
import org.renjin.compiler.ir.tac.statements.BasicBlockEndingStatement;
import org.renjin.compiler.ir.tac.statements.Statement;
import org.renjin.repackaged.guava.collect.Lists;
import org.renjin.repackaged.guava.collect.Maps;
import org.renjin.util.DebugGraph;

public class ControlFlowGraph {
    private final IRBody parent;
    private final List<BasicBlock> basicBlocks;
    private BasicBlock entry;
    private BasicBlock exit;
    private Map<IRLabel, BasicBlock> basicBlockMap = Maps.newHashMap();

    public ControlFlowGraph(IRBody body2) {
        this.parent = body2;
        this.basicBlocks = Lists.newArrayList();
        this.addBasicBlocks();
        this.linkBasicBlocks();
        this.removeDeadBlocks();
    }

    private void addBasicBlocks() {
        this.entry = new BasicBlock(this.parent);
        this.entry.setDebugId("entry");
        this.basicBlocks.add(this.entry);
        BasicBlock current = null;
        for (int i = 0; i < this.parent.getStatements().size(); ++i) {
            Statement stmt = this.parent.getStatements().get(i);
            if (current == null || this.parent.isLabeled(i)) {
                current = this.addNewBasicBlock(this.parent, i);
            } else {
                current.addStatement(stmt);
            }
            if (!(stmt instanceof BasicBlockEndingStatement)) continue;
            current = null;
        }
        this.exit = new BasicBlock(this.parent);
        this.exit.setDebugId("exit");
        this.basicBlocks.add(this.exit);
        this.addEdge(this.entry, this.exit);
    }

    public List<BasicBlock> getLiveBasicBlocks() {
        return Collections.unmodifiableList(this.basicBlocks);
    }

    private BasicBlock addNewBasicBlock(IRBody body2, int i) {
        BasicBlock bb = BasicBlock.createWithStartAt(body2, i);
        bb.setDebugId(this.basicBlocks.size());
        this.basicBlocks.add(bb);
        for (IRLabel label : bb.getLabels()) {
            this.basicBlockMap.put(label, bb);
        }
        return bb;
    }

    private void linkBasicBlocks() {
        for (int i = 1; i < this.basicBlocks.size() - 1; ++i) {
            BasicBlock bb = this.basicBlocks.get(i);
            if (bb.fallsThrough()) {
                this.addEdge(bb, this.basicBlocks.get(i + 1));
                continue;
            }
            if (bb.returns()) {
                this.addEdge(bb, this.exit);
                continue;
            }
            for (IRLabel targetLabel : bb.targets()) {
                BasicBlock targetBB = this.basicBlockMap.get(targetLabel);
                if (targetBB == null) {
                    throw new NullPointerException("whoops! no basic block with label '" + targetLabel + "' in IRBody " + this.parent);
                }
                this.addEdge(bb, targetBB);
            }
        }
        this.addEdge(this.entry, this.basicBlocks.get(1));
    }

    private void addEdge(BasicBlock bb, BasicBlock basicBlock) {
        bb.addFlowSuccessor(basicBlock);
    }

    private void removeDeadBlocks() {
        boolean changing;
        HashSet<BasicBlock> live = new HashSet<BasicBlock>();
        live.add(this.entry);
        live.add(this.basicBlocks.get(1));
        do {
            changing = false;
            for (BasicBlock basicBlock : Lists.newArrayList(live)) {
                if (!live.addAll(basicBlock.getFlowSuccessors())) continue;
                changing = true;
            }
        } while (changing);
        this.basicBlocks.retainAll(live);
        for (BasicBlock basicBlock : this.basicBlocks) {
            basicBlock.flowPredecessors.retainAll(live);
            basicBlock.flowSuccessors.retainAll(live);
        }
        int i = 1;
        for (BasicBlock bb : this.basicBlocks) {
            if (bb == this.entry || bb == this.exit) continue;
            bb.setDebugId(i++);
        }
    }

    public List<BasicBlock> getBasicBlocks() {
        return this.basicBlocks;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (BasicBlock bb : this.basicBlocks) {
            sb.append("\n" + bb.toString());
            if (bb.getLabels() != null) {
                sb.append(": ").append(bb.getLabels());
            }
            sb.append(" =============\n");
            sb.append(bb.statementsToString());
        }
        return sb.toString();
    }

    public BasicBlock getEntry() {
        return this.entry;
    }

    public BasicBlock getExit() {
        return this.exit;
    }

    public List<BasicBlock> getSuccessors(BasicBlock x) {
        return x.getFlowSuccessors();
    }

    public List<BasicBlock> getPredecessors(BasicBlock x) {
        return x.getFlowPredecessors();
    }

    public void dumpGraph() {
        DebugGraph dump = new DebugGraph("compute");
        for (BasicBlock basicBlock : this.basicBlocks) {
            for (BasicBlock successor : basicBlock.getFlowSuccessors()) {
                dump.printEdge(basicBlock.getDebugId(), successor.getDebugId());
            }
        }
        dump.close();
    }

    public void dumpEdges() {
        for (BasicBlock basicBlock : this.basicBlocks) {
            for (BasicBlock block : basicBlock.getFlowSuccessors()) {
                System.out.println("edge[" + basicBlock.getDebugId() + ", " + block.getDebugId() + "]");
            }
        }
    }

    public BasicBlock get(String debugId) {
        for (BasicBlock basicBlock : this.basicBlocks) {
            if (!basicBlock.getDebugId().equals(debugId)) continue;
            return basicBlock;
        }
        throw new IllegalArgumentException("No such block: " + debugId);
    }
}

