/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.compiler.cfg;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.renjin.compiler.cfg.BasicBlock;
import org.renjin.compiler.cfg.ControlFlowGraph;
import org.renjin.repackaged.guava.base.Joiner;
import org.renjin.repackaged.guava.base.Predicates;
import org.renjin.repackaged.guava.collect.HashMultimap;
import org.renjin.repackaged.guava.collect.Iterables;
import org.renjin.repackaged.guava.collect.Multimap;
import org.renjin.repackaged.guava.collect.Sets;
import org.renjin.util.DebugGraph;

public class DominanceTree {
    private final ControlFlowGraph cfg;
    private final HashMultimap<BasicBlock, BasicBlock> Dom = HashMultimap.create();
    private final Multimap<BasicBlock, BasicBlock> dominanceFrontier = HashMultimap.create();

    public DominanceTree(ControlFlowGraph cfg) {
        this.cfg = cfg;
        this.computeDominators();
        this.buildTree();
        this.calculateDominanceFrontiers();
    }

    private void computeDominators() {
        boolean changes;
        this.Dom.put((Object)this.cfg.getEntry(), (Object)this.cfg.getEntry());
        for (BasicBlock n : Iterables.filter(this.cfg.getLiveBasicBlocks(), Predicates.not(Predicates.equalTo(this.cfg.getEntry())))) {
            this.Dom.putAll((Object)n, this.cfg.getLiveBasicBlocks());
        }
        do {
            changes = false;
            for (BasicBlock n : Iterables.filter(this.cfg.getLiveBasicBlocks(), Predicates.not(Predicates.equalTo(this.cfg.getEntry())))) {
                Set<BasicBlock> newDom = this.computeNewDominance(n);
                Set original = this.Dom.get((Object)n);
                if (original.equals(newDom)) continue;
                this.Dom.replaceValues((Object)n, newDom);
                changes = true;
            }
        } while (changes);
    }

    private Set<BasicBlock> computeNewDominance(BasicBlock n) {
        List<BasicBlock> predecessors = n.getFlowPredecessors();
        HashSet<BasicBlock> set2 = new HashSet<BasicBlock>();
        boolean first = true;
        for (BasicBlock predecessor : predecessors) {
            Set frontier = this.Dom.get((Object)predecessor);
            if (first) {
                set2.addAll(frontier);
            } else {
                set2.retainAll(frontier);
            }
            first = false;
        }
        set2.add(n);
        return set2;
    }

    private String toString(Set<BasicBlock> newDom) {
        ArrayList<String> strings = new ArrayList<String>();
        for (BasicBlock basicBlock : newDom) {
            strings.add(basicBlock.getDebugId());
        }
        Collections.sort(strings);
        return "{" + Joiner.on(", ").join(strings) + "}";
    }

    private void buildTree() {
        for (BasicBlock n : this.cfg.getBasicBlocks()) {
            BasicBlock d = this.calculateImmediateDominator(n);
            if (d == null) continue;
            d.addDominanceSuccessor(n);
        }
    }

    private BasicBlock calculateImmediateDominator(BasicBlock n) {
        for (BasicBlock d : this.strictDominators(n)) {
            if (!this.dominatesImmediately(d, n)) continue;
            return d;
        }
        return null;
    }

    public BasicBlock getImmediateDominator(BasicBlock n) {
        List<BasicBlock> parent2 = n.getDominancePredecessors();
        if (parent2.size() != 1) {
            throw new IllegalArgumentException(n.toString());
        }
        return (BasicBlock)parent2.iterator().next();
    }

    public boolean dominatesImmediately(BasicBlock d, BasicBlock n) {
        for (BasicBlock otherDominator : this.strictDominators(n)) {
            if (!this.strictlyDominates(d, otherDominator)) continue;
            return false;
        }
        return true;
    }

    public boolean strictlyDominates(BasicBlock d, BasicBlock n) {
        return !d.equals(n) && this.dominates(d, n);
    }

    private boolean dominates(BasicBlock d, BasicBlock n) {
        if (d == n) {
            return true;
        }
        return this.Dom.containsEntry(n, d);
    }

    private Iterable<BasicBlock> strictDominators(BasicBlock n) {
        return Sets.difference(this.Dom.get((Object)n), Collections.singleton(n));
    }

    private void calculateDominanceFrontiers() {
        this.calculateDominanceFrontier(this.cfg.getEntry());
    }

    private void calculateDominanceFrontier(BasicBlock X) {
        for (BasicBlock child : X.getDominanceSuccessors()) {
            this.calculateDominanceFrontier(child);
        }
        for (BasicBlock Y : this.cfg.getSuccessors(X)) {
            if (this.getImmediateDominator(Y) == X) continue;
            this.dominanceFrontier.put(X, Y);
        }
        for (BasicBlock Z : X.getDominanceSuccessors()) {
            for (BasicBlock Y : this.dominanceFrontier.get(Z)) {
                if (this.getImmediateDominator(Y) == X) continue;
                this.dominanceFrontier.put(X, Y);
            }
        }
    }

    public Collection<BasicBlock> getFrontier(BasicBlock bb) {
        return this.dominanceFrontier.get(bb);
    }

    public Collection<BasicBlock> getChildren(BasicBlock x) {
        return x.getDominanceSuccessors();
    }

    public void dumpGraph() {
        DebugGraph dump = new DebugGraph("dominance");
        for (BasicBlock basicBlock : this.cfg.getBasicBlocks()) {
            for (BasicBlock dominated : basicBlock.getDominanceSuccessors()) {
                dump.printEdge(basicBlock.getDebugId(), dominated.getDebugId());
            }
        }
        dump.close();
    }
}

