/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.compiler.codegen;

import java.util.concurrent.atomic.AtomicLong;
import org.renjin.compiler.CompiledBody;
import org.renjin.compiler.CompiledLoopBody;
import org.renjin.compiler.JitClassLoader;
import org.renjin.compiler.NotCompilableException;
import org.renjin.compiler.TypeSolver;
import org.renjin.compiler.cfg.BasicBlock;
import org.renjin.compiler.cfg.ControlFlowGraph;
import org.renjin.compiler.codegen.EmitContext;
import org.renjin.compiler.codegen.VariableSlots;
import org.renjin.compiler.ir.exception.InternalCompilerException;
import org.renjin.compiler.ir.tac.IRLabel;
import org.renjin.compiler.ir.tac.statements.Statement;
import org.renjin.eval.Context;
import org.renjin.repackaged.asm.ClassVisitor;
import org.renjin.repackaged.asm.ClassWriter;
import org.renjin.repackaged.asm.MethodVisitor;
import org.renjin.repackaged.asm.Opcodes;
import org.renjin.repackaged.asm.Type;
import org.renjin.repackaged.asm.commons.InstructionAdapter;
import org.renjin.sexp.Environment;
import org.renjin.sexp.SEXP;

public class ByteCodeEmitter
implements Opcodes {
    private static final AtomicLong CLASS_COUNTER = new AtomicLong(1L);
    private ClassWriter cw;
    private ClassVisitor cv;
    private ControlFlowGraph cfg;
    private String className;
    private TypeSolver types;

    public ByteCodeEmitter(ControlFlowGraph cfg, TypeSolver types) {
        this.cfg = cfg;
        this.types = types;
        this.className = "Body" + CLASS_COUNTER.getAndIncrement();
    }

    public Class<CompiledBody> compile() {
        this.startClass(CompiledBody.class);
        this.writeImplementation();
        this.writeConstructor();
        this.writeClassEnd();
        return JitClassLoader.defineClass(CompiledBody.class, this.className.replace('/', '.'), this.cw.toByteArray());
    }

    public Class<CompiledLoopBody> compileLoopBody() {
        this.startClass(CompiledLoopBody.class);
        this.writeLoopImplementation();
        this.writeConstructor();
        this.writeClassEnd();
        return JitClassLoader.defineClass(CompiledLoopBody.class, this.className.replace('/', '.'), this.cw.toByteArray());
    }

    private void startClass(Class<?> interfaceClass) {
        this.cw = new ClassWriter(2);
        this.cv = this.cw;
        this.cv.visit(50, 33, this.className, null, Type.getInternalName(Object.class), new String[]{Type.getInternalName(interfaceClass)});
    }

    private void writeConstructor() {
        MethodVisitor mv = this.cv.visitMethod(1, "<init>", "()V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, Type.getInternalName(Object.class), "<init>", "()V", false);
        mv.visitInsn(177);
        mv.visitMaxs(2, 1);
        mv.visitEnd();
    }

    private void writeImplementation() {
        int argumentSize = 3;
        VariableSlots variableSlots = new VariableSlots(argumentSize, this.types);
        EmitContext emitContext = new EmitContext(this.cfg, argumentSize, variableSlots);
        MethodVisitor mv = this.cv.visitMethod(1, "evaluate", Type.getMethodDescriptor(Type.VOID_TYPE, Type.getType(Context.class), Type.getType(Environment.class)), null, null);
        mv.visitCode();
        this.writeBody(emitContext, mv);
        mv.visitEnd();
    }

    private void writeLoopImplementation() {
        int argumentSize = 5;
        VariableSlots variableSlots = new VariableSlots(argumentSize, this.types);
        EmitContext emitContext = new EmitContext(this.cfg, argumentSize, variableSlots);
        emitContext.setLoopVectorIndex(3);
        emitContext.setLoopIterationIndex(4);
        MethodVisitor mv = this.cv.visitMethod(1, "run", Type.getMethodDescriptor(Type.VOID_TYPE, Type.getType(Context.class), Type.getType(Environment.class), Type.getType(SEXP.class), Type.INT_TYPE), null, null);
        mv.visitCode();
        this.writeBody(emitContext, mv);
        mv.visitEnd();
    }

    private void writeBody(EmitContext emitContext, MethodVisitor mv) {
        InstructionAdapter instructionAdapter = new InstructionAdapter(mv);
        for (BasicBlock basicBlock : this.cfg.getBasicBlocks()) {
            if (basicBlock == this.cfg.getEntry() || basicBlock == this.cfg.getExit()) continue;
            for (IRLabel label : basicBlock.getLabels()) {
                mv.visitLabel(emitContext.getAsmLabel(label));
            }
            for (Statement stmt : basicBlock.getStatements()) {
                try {
                    stmt.emit(emitContext, instructionAdapter);
                }
                catch (NotCompilableException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new InternalCompilerException("Exception compiling statement " + stmt, e);
                }
            }
        }
        mv.visitMaxs(0, emitContext.getLocalVariableCount());
    }

    private void writeClassEnd() {
        this.cv.visitEnd();
    }

    private class MyClassLoader
    extends ClassLoader {
        public MyClassLoader(ClassLoader parent2) {
            super(parent2);
        }

        Class defineClass(String name, byte[] b) {
            return this.defineClass(name, b, 0, b.length);
        }
    }
}

