/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.compiler.ir.ssa;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.renjin.compiler.cfg.FlowEdge;
import org.renjin.compiler.codegen.EmitContext;
import org.renjin.compiler.ir.ValueBounds;
import org.renjin.compiler.ir.tac.expressions.Expression;
import org.renjin.compiler.ir.tac.expressions.Variable;
import org.renjin.repackaged.asm.Type;
import org.renjin.repackaged.asm.commons.InstructionAdapter;
import org.renjin.repackaged.guava.base.Joiner;
import org.renjin.repackaged.guava.collect.Lists;

public class PhiFunction
implements Expression {
    private List<Variable> arguments;
    private List<FlowEdge> incomingEdges;

    public PhiFunction(Variable variable, Set<FlowEdge> incomingEdges) {
        if (incomingEdges.size() < 2) {
            throw new IllegalArgumentException("variable=" + variable + ", count=" + incomingEdges.size() + " (count must be >= 2)");
        }
        this.incomingEdges = Lists.newArrayList(incomingEdges);
        this.arguments = Lists.newArrayList();
        for (int i = 0; i != incomingEdges.size(); ++i) {
            this.arguments.add(variable);
        }
    }

    public List<Variable> getArguments() {
        return this.arguments;
    }

    public String toString() {
        return "\u03a6(" + Joiner.on(", ").join(this.arguments) + ")";
    }

    @Override
    public boolean isDefinitelyPure() {
        return false;
    }

    @Override
    public int load(EmitContext emitContext, InstructionAdapter mv) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Type getType() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ValueBounds updateTypeBounds(Map<Expression, ValueBounds> typeMap) {
        Iterator<Variable> it = this.arguments.iterator();
        ValueBounds bounds = it.next().updateTypeBounds(typeMap);
        while (it.hasNext()) {
            bounds = bounds.union(it.next().updateTypeBounds(typeMap));
        }
        return bounds;
    }

    @Override
    public ValueBounds getValueBounds() {
        throw new UnsupportedOperationException();
    }

    public List<FlowEdge> getIncomingEdges() {
        return this.incomingEdges;
    }

    public void setVersionNumber(int argumentIndex, int versionNumber) {
        this.arguments.set(argumentIndex, this.arguments.get(argumentIndex).getVersion(versionNumber));
    }

    public Variable getArgument(int j) {
        return this.arguments.get(j);
    }

    @Override
    public void setChild(int childIndex, Expression child) {
        this.arguments.set(childIndex, (Variable)child);
    }

    @Override
    public int getChildCount() {
        return this.arguments.size();
    }

    @Override
    public Expression childAt(int index) {
        return this.arguments.get(index);
    }
}

