/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.compiler.ir.tac;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.renjin.compiler.NotCompilableException;
import org.renjin.compiler.ir.ValueBounds;
import org.renjin.compiler.ir.exception.InvalidSyntaxException;
import org.renjin.compiler.ir.tac.IRArgument;
import org.renjin.compiler.ir.tac.IRBody;
import org.renjin.compiler.ir.tac.IRLabel;
import org.renjin.compiler.ir.tac.InlinedContext;
import org.renjin.compiler.ir.tac.RuntimeState;
import org.renjin.compiler.ir.tac.expressions.Constant;
import org.renjin.compiler.ir.tac.expressions.EnvironmentVariable;
import org.renjin.compiler.ir.tac.expressions.Expression;
import org.renjin.compiler.ir.tac.expressions.LocalVariable;
import org.renjin.compiler.ir.tac.expressions.ReadEnvironment;
import org.renjin.compiler.ir.tac.expressions.ReadLoopIt;
import org.renjin.compiler.ir.tac.expressions.ReadLoopVector;
import org.renjin.compiler.ir.tac.expressions.ReadParam;
import org.renjin.compiler.ir.tac.expressions.SimpleExpression;
import org.renjin.compiler.ir.tac.expressions.Temp;
import org.renjin.compiler.ir.tac.functions.ForTranslator;
import org.renjin.compiler.ir.tac.functions.FunctionCallTranslator;
import org.renjin.compiler.ir.tac.functions.FunctionCallTranslators;
import org.renjin.compiler.ir.tac.functions.LoopBodyContext;
import org.renjin.compiler.ir.tac.functions.TranslationContext;
import org.renjin.compiler.ir.tac.statements.Assignment;
import org.renjin.compiler.ir.tac.statements.ExprStatement;
import org.renjin.compiler.ir.tac.statements.GotoStatement;
import org.renjin.compiler.ir.tac.statements.IfStatement;
import org.renjin.compiler.ir.tac.statements.ReturnStatement;
import org.renjin.compiler.ir.tac.statements.Statement;
import org.renjin.repackaged.guava.collect.Lists;
import org.renjin.repackaged.guava.collect.Maps;
import org.renjin.sexp.Closure;
import org.renjin.sexp.ExpressionVector;
import org.renjin.sexp.Function;
import org.renjin.sexp.FunctionCall;
import org.renjin.sexp.Null;
import org.renjin.sexp.PairList;
import org.renjin.sexp.PrimitiveFunction;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.Symbol;
import org.renjin.sexp.Symbols;

public class IRBodyBuilder {
    private int nextTemp = 0;
    private int nextLabel = 0;
    private FunctionCallTranslators builders = new FunctionCallTranslators();
    private List<Statement> statements;
    private IRLabel currentLabel;
    private Map<IRLabel, Integer> labels;
    private Map<Symbol, EnvironmentVariable> variables = Maps.newHashMap();
    private RuntimeState runtimeContext;
    private Map<String, Integer> localVariableNames = Maps.newHashMap();
    private Set<Symbol> paramSet = new HashSet<Symbol>();

    public IRBodyBuilder(RuntimeState runtimeState) {
        this.runtimeContext = runtimeState;
    }

    public RuntimeState getRuntimeState() {
        return this.runtimeContext;
    }

    public IRBody build(SEXP exp2) {
        this.statements = Lists.newArrayList();
        this.labels = Maps.newHashMap();
        TopLevelContext context = new TopLevelContext();
        Expression returnValue = this.translateExpression(context, exp2);
        this.addStatement(new ReturnStatement(returnValue));
        this.removeRedundantJumps();
        this.insertVariableInitializations();
        this.updateVariableReturn();
        return new IRBody(this.statements, this.labels);
    }

    public IRBody buildLoopBody(FunctionCall call2, SEXP sequence) {
        this.statements = Lists.newArrayList();
        this.labels = Maps.newHashMap();
        LocalVariable vector2 = this.newLocalVariable("elements");
        LocalVariable counter = this.newLocalVariable("i");
        this.statements.add(new Assignment(vector2, new ReadLoopVector(sequence)));
        this.statements.add(new Assignment(counter, new ReadLoopIt()));
        LoopBodyContext bodyContext = new LoopBodyContext(this.runtimeContext);
        ForTranslator.buildLoop(bodyContext, this, call2, vector2, counter);
        this.addStatement(new ReturnStatement(new Constant(Null.INSTANCE)));
        this.removeRedundantJumps();
        this.insertVariableInitializations();
        this.updateVariableReturn();
        return new IRBody(this.statements, this.labels);
    }

    public IRBody buildFunctionBody(Closure closure, Set<Symbol> suppliedArguments) {
        this.statements = Lists.newArrayList();
        this.labels = Maps.newHashMap();
        for (PairList.Node node : closure.getFormals().nodes()) {
            this.paramSet.add(node.getTag());
        }
        ArrayList<ReadParam> params = Lists.newArrayList();
        for (PairList.Node formal : closure.getFormals().nodes()) {
            if (!suppliedArguments.contains(formal.getTag())) continue;
            ReadParam paramExpr = new ReadParam(formal.getTag());
            this.statements.add(new Assignment(new EnvironmentVariable(formal.getTag()), paramExpr));
            params.add(paramExpr);
        }
        for (PairList.Node formal : closure.getFormals().nodes()) {
            if (suppliedArguments.contains(formal.getTag())) continue;
            SEXP defaultValue = formal.getValue();
            if (defaultValue == Symbol.MISSING_ARG) {
                throw new InvalidSyntaxException("argument '" + formal.getTag() + "' is missing, with no default");
            }
            if (!this.isConstant(defaultValue)) {
                throw new NotCompilableException(defaultValue, "argument '" + formal.getName() + "' has not been provided" + " and has a default value with (potential) side effects.");
            }
            this.statements.add(new Assignment(new EnvironmentVariable(formal.getTag()), new Constant(formal.getValue())));
        }
        InlinedContext context = new InlinedContext();
        Expression returnValue = this.translateExpression(context, closure.getBody());
        this.addStatement(new ReturnStatement(returnValue));
        this.removeRedundantJumps();
        this.insertVariableInitializations();
        IRBody body2 = new IRBody(this.statements, this.labels);
        body2.setParams(params);
        return body2;
    }

    private boolean isConstant(SEXP defaultValue) {
        return !(defaultValue instanceof Symbol) && !(defaultValue instanceof ExpressionVector) && !(defaultValue instanceof FunctionCall);
    }

    private void updateVariableReturn() {
        for (Statement statement : this.statements) {
            if (!(statement instanceof ReturnStatement)) continue;
            ((ReturnStatement)statement).addEnvironmentVariables(this.variables.values());
        }
    }

    private void insertVariableInitializations() {
        ArrayList<Assignment> initializations = new ArrayList<Assignment>();
        for (EnvironmentVariable environmentVariable : this.variables.values()) {
            SEXP value;
            if (this.paramSet.contains(environmentVariable.getName()) || (value = this.runtimeContext.findVariable(environmentVariable.getName())) == Symbol.UNBOUND_VALUE) continue;
            initializations.add(new Assignment(environmentVariable, new ReadEnvironment(environmentVariable.getName(), ValueBounds.of(value))));
        }
        this.statements.addAll(0, initializations);
        for (IRLabel label : this.labels.keySet()) {
            this.labels.put(label, this.labels.get(label) + initializations.size());
        }
    }

    public void dump(SEXP exp2) {
        System.out.println(this.build(exp2).toString());
    }

    public Expression translateExpression(TranslationContext context, SEXP exp2) {
        if (exp2 instanceof ExpressionVector) {
            return this.translateExpressionList(context, (ExpressionVector)exp2);
        }
        if (exp2 instanceof Symbol) {
            if (exp2 == Symbol.MISSING_ARG) {
                return new Constant(exp2);
            }
            return this.getEnvironmentVariable((Symbol)exp2);
        }
        if (exp2 instanceof FunctionCall) {
            return this.translateCallExpression(context, (FunctionCall)exp2);
        }
        return new Constant(exp2);
    }

    public EnvironmentVariable getEnvironmentVariable(Symbol name) {
        EnvironmentVariable var = this.variables.get(name);
        if (var == null) {
            var = new EnvironmentVariable(name);
            this.variables.put(name, var);
        }
        return var;
    }

    public void translateStatements(TranslationContext context, SEXP sexp2) {
        if (sexp2 instanceof FunctionCall) {
            FunctionCall call2 = (FunctionCall)sexp2;
            Function function2 = this.resolveFunction(call2.getFunction());
            this.builders.get(function2).addStatement(this, context, function2, call2);
        } else {
            Expression expr = this.translateExpression(context, sexp2);
            if (!(expr instanceof Constant)) {
                this.addStatement(new ExprStatement(expr));
            }
        }
    }

    public Expression translateSetterCall(TranslationContext context, FunctionCall getterCall, Expression rhs) {
        Symbol getter = (Symbol)getterCall.getFunction();
        Function setter = this.resolveFunction(Symbol.get(getter.getPrintName() + "<-"));
        FunctionCallTranslator translator = this.builders.get(setter);
        return translator.translateToSetterExpression(this, context, setter, getterCall, rhs);
    }

    public Expression translateCallExpression(TranslationContext context, FunctionCall call2) {
        SEXP functionName = call2.getFunction();
        Function function2 = this.resolveFunction(functionName);
        FunctionCallTranslator translator = this.builders.get(function2);
        return translator.translateToExpression(this, context, function2, call2);
    }

    private Function resolveFunction(SEXP functionName) {
        if (functionName instanceof PrimitiveFunction) {
            return (PrimitiveFunction)functionName;
        }
        if (functionName instanceof Symbol) {
            return this.runtimeContext.findFunction((Symbol)functionName);
        }
        throw new NotCompilableException(functionName);
    }

    public List<IRArgument> translateArgumentList(TranslationContext context, PairList argumentSexps) {
        ArrayList<IRArgument> arguments = Lists.newArrayList();
        for (PairList.Node argNode : argumentSexps.nodes()) {
            if (argNode.getValue() == Symbols.ELLIPSES) {
                for (PairList.Node extraArgument : context.getEllipsesArguments().nodes()) {
                    SimpleExpression expression2 = this.simplify(this.translateExpression(context, extraArgument));
                    arguments.add(new IRArgument(extraArgument.getRawTag(), expression2));
                }
                continue;
            }
            SimpleExpression argExpression = this.simplify(this.translateExpression(context, argNode.getValue()));
            arguments.add(new IRArgument(argNode.getRawTag(), argExpression));
        }
        return arguments;
    }

    public SimpleExpression simplify(Expression rvalue) {
        if (rvalue instanceof SimpleExpression) {
            return (SimpleExpression)rvalue;
        }
        Temp temp = this.newTemp();
        this.addStatement(new Assignment(temp, rvalue));
        return temp;
    }

    public SimpleExpression translateSimpleExpression(TranslationContext context, SEXP exp2) {
        return this.simplify(this.translateExpression(context, exp2));
    }

    private Expression translateExpressionList(TranslationContext context, ExpressionVector vector2) {
        if (vector2.length() == 0) {
            return new Constant(Null.INSTANCE);
        }
        int i = 0;
        while (i + 1 < vector2.length()) {
            this.translateStatements(context, vector2.getElementAsSEXP(i));
            ++i;
        }
        return this.translateExpression(context, vector2.getElementAsSEXP(vector2.length() - 1));
    }

    public Temp newTemp() {
        return new Temp(this.nextTemp++);
    }

    public LocalVariable newLocalVariable(String debugName) {
        String name;
        int index;
        if (this.localVariableNames.containsKey(debugName)) {
            index = this.localVariableNames.get(debugName) + 1;
            name = debugName + index;
        } else {
            index = 1;
            name = debugName;
        }
        this.localVariableNames.put(debugName, index);
        return new LocalVariable("_" + name);
    }

    public IRLabel newLabel() {
        return new IRLabel(this.nextLabel++);
    }

    public void addStatement(Statement statement) {
        this.statements.add(statement);
        this.currentLabel = null;
    }

    public IRLabel addLabel() {
        if (this.currentLabel != null) {
            return this.currentLabel;
        }
        IRLabel newLabel = this.newLabel();
        this.addLabel(newLabel);
        return newLabel;
    }

    public void addLabel(IRLabel label) {
        this.labels.put(label, this.statements.size());
        this.currentLabel = label;
    }

    private void removeRedundantJumps() {
        boolean changed;
        do {
            changed = false;
            for (int i = 0; i != this.statements.size(); ++i) {
                IRLabel newFalseTarget;
                Statement stmt = this.statements.get(i);
                if (!(stmt instanceof IfStatement)) continue;
                IfStatement ifStmt = (IfStatement)stmt;
                IRLabel newTrueTarget = this.ultimateTarget(ifStmt.getTrueTarget());
                if (newTrueTarget != null) {
                    this.statements.set(i, ifStmt.setTrueTarget(newTrueTarget));
                    changed = true;
                }
                if ((newFalseTarget = this.ultimateTarget(ifStmt.getFalseTarget())) == null) continue;
                this.statements.set(i, ifStmt.setFalseTarget(newFalseTarget));
                changed = true;
            }
        } while (changed);
    }

    private IRLabel ultimateTarget(IRLabel label) {
        Statement targetStmt = this.statements.get(this.labels.get(label));
        if (targetStmt instanceof GotoStatement) {
            return ((GotoStatement)targetStmt).getTarget();
        }
        return null;
    }

    private static class TopLevelContext
    implements TranslationContext {
        private TopLevelContext() {
        }

        @Override
        public PairList getEllipsesArguments() {
            throw new InvalidSyntaxException("'...' used outside of a function");
        }
    }
}

