/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.compiler.ir.tac.functions;

import org.renjin.compiler.ir.tac.IRBodyBuilder;
import org.renjin.compiler.ir.tac.expressions.Constant;
import org.renjin.compiler.ir.tac.expressions.EnvironmentVariable;
import org.renjin.compiler.ir.tac.expressions.Expression;
import org.renjin.compiler.ir.tac.expressions.LValue;
import org.renjin.compiler.ir.tac.expressions.Temp;
import org.renjin.compiler.ir.tac.functions.FunctionCallTranslator;
import org.renjin.compiler.ir.tac.functions.TranslationContext;
import org.renjin.compiler.ir.tac.statements.Assignment;
import org.renjin.eval.EvalException;
import org.renjin.sexp.Function;
import org.renjin.sexp.FunctionCall;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.StringVector;
import org.renjin.sexp.Symbol;

public class AssignLeftTranslator
extends FunctionCallTranslator {
    @Override
    public Expression translateToExpression(IRBodyBuilder builder, TranslationContext context, Function resolvedFunction, FunctionCall call2) {
        Expression rhs = builder.translateExpression(context, (SEXP)call2.getArgument(1));
        if (!(rhs instanceof Constant)) {
            Temp temp = builder.newTemp();
            builder.addStatement(new Assignment(temp, rhs));
            rhs = temp;
        }
        this.addAssignment(builder, context, call2, rhs);
        return rhs;
    }

    @Override
    public void addStatement(IRBodyBuilder builder, TranslationContext context, Function resolvedFunction, FunctionCall assignment) {
        Expression rhs = builder.translateExpression(context, (SEXP)assignment.getArgument(1));
        this.addAssignment(builder, context, assignment, rhs);
    }

    private void addAssignment(IRBodyBuilder builder, TranslationContext context, FunctionCall assignment, Expression rhs) {
        EnvironmentVariable target;
        Object lhs = assignment.getArgument(0);
        while (lhs instanceof FunctionCall) {
            FunctionCall call2 = (FunctionCall)lhs;
            rhs = builder.translateSetterCall(context, call2, rhs);
            lhs = call2.getArgument(0);
        }
        if (lhs instanceof Symbol) {
            target = builder.getEnvironmentVariable((Symbol)lhs);
        } else if (lhs instanceof StringVector) {
            target = builder.getEnvironmentVariable(Symbol.get(((StringVector)lhs).getElementAsString(0)));
        } else {
            throw new EvalException("cannot assign to value of type " + lhs.getTypeName(), new Object[0]);
        }
        this.doAssignment(builder, target, rhs);
    }

    protected void doAssignment(IRBodyBuilder builder, LValue target, Expression rhs) {
        builder.addStatement(new Assignment(target, rhs));
    }
}

