/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.compiler.pipeline;

import org.renjin.compiler.pipeline.DeferredJitter;
import org.renjin.compiler.pipeline.DeferredNode;
import org.renjin.compiler.pipeline.JitKey;
import org.renjin.compiler.pipeline.JittedComputation;
import org.renjin.repackaged.guava.cache.Cache;
import org.renjin.repackaged.guava.cache.CacheBuilder;

public class DeferredJitCache {
    public static final DeferredJitCache INSTANCE = new DeferredJitCache();
    private final Cache<JitKey, JittedComputation> cache = CacheBuilder.newBuilder().softValues().maximumSize(100L).build();

    private DeferredJitCache() {
    }

    public JittedComputation compile(DeferredNode node) {
        JitKey key = node.jitKey();
        JittedComputation computation = this.cache.getIfPresent(key);
        if (computation != null) {
            return computation;
        }
        DeferredJitter jitter = new DeferredJitter();
        computation = jitter.compile(node);
        this.cache.put(key, computation);
        return computation;
    }
}

