/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.compiler.pipeline;

import org.renjin.compiler.pipeline.DeferredJitCache;
import org.renjin.compiler.pipeline.DeferredNode;
import org.renjin.compiler.pipeline.JittedComputation;
import org.renjin.compiler.pipeline.VectorPipeliner;
import org.renjin.primitives.vector.MemoizedComputation;
import org.renjin.sexp.DoubleArrayVector;
import org.renjin.sexp.Vector;

public class DeferredNodeComputer
implements Runnable {
    private final DeferredNode node;

    public DeferredNodeComputer(DeferredNode node) {
        this.node = node;
    }

    @Override
    public void run() {
        if (this.node.getComputation().getComputationName().equals("mean") || this.node.getComputation().getComputationName().equals("rowMeans") || this.node.getComputation().getComputationName().equals("sum")) {
            try {
                Vector[] operands = this.node.flattenVectors();
                JittedComputation computer = DeferredJitCache.INSTANCE.compile(this.node);
                long start = System.nanoTime();
                DoubleArrayVector result = DoubleArrayVector.unsafe(computer.compute(operands));
                long time2 = System.nanoTime() - start;
                if (VectorPipeliner.DEBUG) {
                    System.out.println("compute: " + (double)time2 / 1000000.0 + "ms");
                }
                ((MemoizedComputation)this.node.getVector()).setResult(result);
                this.node.setResult(result);
            }
            catch (Throwable e) {
                throw new RuntimeException("Exception compiling node " + this.node, e);
            }
        } else if (this.node.getVector() instanceof MemoizedComputation) {
            this.node.setResult(((MemoizedComputation)this.node.getVector()).forceResult());
        }
    }
}

