/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.compiler.pipeline.accessor;

import org.renjin.compiler.pipeline.ComputeMethod;
import org.renjin.compiler.pipeline.DeferredNode;
import org.renjin.compiler.pipeline.accessor.Accessor;
import org.renjin.compiler.pipeline.accessor.Accessors;
import org.renjin.compiler.pipeline.accessor.InputGraph;
import org.renjin.repackaged.asm.MethodVisitor;

public class DistanceMatrixAccessor
extends Accessor {
    private int operandIndex;
    private Accessor operandAccessor;
    private int indexTempLocal;
    private int rowTempLocal;
    private int colTempLocal;

    public DistanceMatrixAccessor(DeferredNode node, InputGraph inputGraph) {
        this.operandIndex = inputGraph.getOperandIndex(node);
        this.operandAccessor = Accessors.create(node.getOperands().get(0), inputGraph);
    }

    @Override
    public void init(ComputeMethod method) {
        this.operandAccessor.init(method);
        this.indexTempLocal = method.reserveLocal(1);
        this.rowTempLocal = method.reserveLocal(1);
        this.colTempLocal = method.reserveLocal(1);
    }

    @Override
    public void pushLength(ComputeMethod method) {
        this.operandAccessor.pushLength(method);
        MethodVisitor mv = method.getVisitor();
        mv.visitInsn(89);
        mv.visitInsn(104);
    }

    @Override
    public void pushDouble(ComputeMethod method) {
        MethodVisitor mv = method.getVisitor();
        mv.visitInsn(89);
        mv.visitVarInsn(54, this.indexTempLocal);
        this.operandAccessor.pushLength(method);
        mv.visitInsn(112);
        mv.visitVarInsn(54, this.rowTempLocal);
        mv.visitVarInsn(21, this.indexTempLocal);
        this.operandAccessor.pushLength(method);
        mv.visitInsn(108);
        mv.visitVarInsn(54, this.colTempLocal);
        mv.visitVarInsn(21, this.rowTempLocal);
        this.operandAccessor.pushDouble(method);
        mv.visitVarInsn(21, this.colTempLocal);
        this.operandAccessor.pushDouble(method);
        mv.visitInsn(103);
        mv.visitMethodInsn(184, "java/lang/Math", "abs", "(D)D");
    }
}

