/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.compiler.pipeline.optimize;

import java.util.ArrayList;
import java.util.List;
import org.renjin.compiler.pipeline.DeferredGraph;
import org.renjin.compiler.pipeline.DeferredNode;
import org.renjin.compiler.pipeline.optimize.AttributeRemover;
import org.renjin.compiler.pipeline.optimize.IdentityRemover;
import org.renjin.compiler.pipeline.optimize.Optimizer;
import org.renjin.compiler.pipeline.optimize.SquareOptimizer;
import org.renjin.repackaged.guava.collect.Lists;

public class Optimizers {
    List<Optimizer> optimizers = Lists.newArrayList();

    public Optimizers() {
        this.optimizers.add(new SquareOptimizer());
        this.optimizers.add(new IdentityRemover());
        this.optimizers.add(new AttributeRemover());
    }

    public void optimize(DeferredGraph graph) {
        boolean changed;
        do {
            changed = false;
            ArrayList<DeferredNode> nodes = Lists.newArrayList(graph.getNodes());
            for (DeferredNode node : nodes) {
                for (Optimizer optimizer : this.optimizers) {
                    changed |= optimizer.optimize(graph, node);
                }
            }
        } while (changed);
    }
}

