/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.eval;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.ListIterator;
import org.renjin.eval.Calls;
import org.renjin.eval.ConditionException;
import org.renjin.eval.Context;
import org.renjin.eval.DispatchChain;
import org.renjin.eval.EvalException;
import org.renjin.primitives.CollectionUtils;
import org.renjin.primitives.special.ReturnException;
import org.renjin.repackaged.guava.base.Joiner;
import org.renjin.repackaged.guava.collect.Collections2;
import org.renjin.repackaged.guava.collect.Iterators;
import org.renjin.repackaged.guava.collect.Lists;
import org.renjin.repackaged.guava.collect.PeekingIterator;
import org.renjin.sexp.Closure;
import org.renjin.sexp.Environment;
import org.renjin.sexp.FunctionCall;
import org.renjin.sexp.ListVector;
import org.renjin.sexp.Null;
import org.renjin.sexp.PairList;
import org.renjin.sexp.Promise;
import org.renjin.sexp.PromisePairList;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.Symbol;
import org.renjin.sexp.Symbols;

public class ClosureDispatcher {
    private final FunctionCall call;
    private final Environment callingEnvironment;
    private final Context callingContext;
    private DispatchChain dispatchChain;

    public ClosureDispatcher(Context callingContext, Environment callingEnvironment, FunctionCall call2) {
        this.call = call2;
        this.callingEnvironment = callingEnvironment;
        this.callingContext = callingContext;
    }

    public SEXP apply(DispatchChain chain, PairList arguments) {
        this.dispatchChain = chain;
        return this.apply(chain.getClosure(), arguments);
    }

    public SEXP applyClosure(Closure closure, PairList args2) {
        PairList promisedArgs = Calls.promiseArgs(args2, this.callingContext, this.callingEnvironment);
        return this.apply(closure, promisedArgs);
    }

    private SEXP apply(Closure closure, PairList promisedArgs) {
        Context functionContext = this.callingContext.beginFunction(this.callingEnvironment, this.call, closure, promisedArgs);
        Environment functionEnvironment = functionContext.getEnvironment();
        try {
            ClosureDispatcher.matchArgumentsInto(closure.getFormals(), promisedArgs, functionContext, functionEnvironment);
            if (this.dispatchChain != null) {
                this.dispatchChain.populateEnvironment(functionEnvironment);
            }
            SEXP result = closure.doApply(functionContext);
            functionContext.exit();
            return result;
        }
        catch (ReturnException e) {
            if (e.getEnvironment() != functionEnvironment) {
                throw e;
            }
            return e.getValue();
        }
        catch (ConditionException e) {
            if (e.getHandlerContext() == functionContext) {
                return new ListVector(e.getCondition(), Null.INSTANCE, e.getHandler());
            }
            throw e;
        }
        catch (EvalException e) {
            e.initContext(functionContext);
            SEXP handler = ClosureDispatcher.findHandler(functionContext, Arrays.asList("simpleError", "error", "condition"));
            if (handler != null) {
                return new ListVector(e.getCondition(), Null.INSTANCE, handler);
            }
            throw e;
        }
    }

    private static SEXP findHandler(Context context, Iterable<String> conditionClasses) {
        for (String conditionClass : conditionClasses) {
            SEXP handler = context.getConditionHandler(conditionClass);
            if (handler == null) continue;
            return handler;
        }
        return null;
    }

    public static void matchArgumentsInto(PairList formals2, PairList actuals, Context innerContext, Environment innerEnv) {
        PairList matched = ClosureDispatcher.matchArguments(formals2, actuals);
        for (PairList.Node node : matched.nodes()) {
            SEXP defaultValue;
            SEXP value = node.getValue();
            if (value == Symbol.MISSING_ARG && (defaultValue = formals2.findByTag(node.getTag())) != Symbol.MISSING_ARG) {
                value = Promise.promiseMissing(innerEnv, defaultValue);
            }
            innerEnv.setVariable(node.getTag(), value);
        }
    }

    public static PairList matchArguments(PairList formals2, PairList actuals) {
        return ClosureDispatcher.matchArguments(formals2, actuals, true);
    }

    public static PairList matchArguments(PairList formals2, PairList actuals, boolean populateMissing) {
        PairList.Builder result = new PairList.Builder();
        ArrayList<PairList.Node> unmatchedActuals = Lists.newArrayList();
        for (PairList.Node argNode : actuals.nodes()) {
            unmatchedActuals.add(argNode);
        }
        ArrayList<PairList.Node> unmatchedFormals = Lists.newArrayList(formals2.nodes());
        ListIterator formalIt = unmatchedFormals.listIterator();
        while (formalIt.hasNext()) {
            Symbol name;
            PairList.Node formal = (PairList.Node)formalIt.next();
            if (!formal.hasTag() || (name = formal.getTag()) == Symbols.ELLIPSES) continue;
            Collection<PairList.Node> matches = Collections2.filter(unmatchedActuals, PairList.Predicates.matches(name));
            if (matches.size() == 1) {
                PairList.Node match2 = ClosureDispatcher.first(matches);
                SEXP value = match2.getValue();
                result.add(name, value);
                formalIt.remove();
                unmatchedActuals.remove(match2);
                continue;
            }
            if (matches.size() <= 1) continue;
            throw new EvalException(String.format("Multiple named values provided for argument '%s'", name.getPrintName()), new Object[0]);
        }
        Collection<PairList.Node> remainingNamedFormals = Collections2.filter(unmatchedFormals, PairList.Predicates.hasTag());
        Iterator actualIt = unmatchedActuals.iterator();
        while (actualIt.hasNext()) {
            PairList.Node partialMatch;
            PairList.Node actual = (PairList.Node)actualIt.next();
            if (!actual.hasTag() || actual.getTag() == Symbols.ELLIPSES || (partialMatch = ClosureDispatcher.matchPartial(actual.getTag().getPrintName(), remainingNamedFormals)) == null) continue;
            result.add(partialMatch.getTag(), actual.getValue());
            actualIt.remove();
            unmatchedFormals.remove(partialMatch);
        }
        Iterator formalIt2 = unmatchedFormals.iterator();
        PeekingIterator<PairList.Node> actualIt2 = Iterators.peekingIterator(unmatchedActuals.iterator());
        while (formalIt2.hasNext()) {
            PairList.Node formal = (PairList.Node)formalIt2.next();
            if (Symbols.ELLIPSES.equals(formal.getTag())) {
                PromisePairList.Builder promises = new PromisePairList.Builder();
                while (actualIt2.hasNext()) {
                    PairList.Node actual = actualIt2.next();
                    promises.add(actual.getRawTag(), actual.getValue());
                }
                result.add(formal.getTag(), (SEXP)promises.build());
                continue;
            }
            if (ClosureDispatcher.hasNextUnTagged(actualIt2)) {
                result.add(formal.getTag(), ClosureDispatcher.nextUnTagged(actualIt2).getValue());
                continue;
            }
            if (!populateMissing) continue;
            result.add(formal.getTag(), (SEXP)Symbol.MISSING_ARG);
        }
        if (actualIt2.hasNext()) {
            throw new EvalException("Unmatched positional arguments", new Object[0]);
        }
        return result.build();
    }

    private static PairList.Node matchPartial(String argumentName, Collection<PairList.Node> formals2) {
        PairList.Node partialMatch = null;
        for (PairList.Node formal : formals2) {
            if (formal.getTag() == Symbols.ELLIPSES) break;
            if (!formal.getTag().getPrintName().startsWith(argumentName)) continue;
            if (partialMatch == null) {
                partialMatch = formal;
                continue;
            }
            throw new EvalException(String.format("Provided argument '%s' matches multiple named formal arguments", argumentName), new Object[0]);
        }
        return partialMatch;
    }

    private static boolean hasNextUnTagged(PeekingIterator<PairList.Node> it) {
        return it.hasNext() && !it.peek().hasTag();
    }

    private static PairList.Node nextUnTagged(Iterator<PairList.Node> it) {
        PairList.Node arg = it.next();
        while (arg.hasTag()) {
            arg = it.next();
        }
        return arg;
    }

    private static String argumentTagList(Collection<PairList.Node> matches) {
        return Joiner.on(", ").join(Collections2.transform(matches, new CollectionUtils.TagName()));
    }

    private static <X> X first(Iterable<X> values) {
        return values.iterator().next();
    }
}

