/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.invoke.codegen;

import com.sun.codemodel.JArray;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JConditional;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.math.complex.Complex;
import org.renjin.invoke.codegen.WrapperGenerator2;
import org.renjin.invoke.model.JvmMethod;
import org.renjin.invoke.model.PrimitiveModel;
import org.renjin.primitives.vector.DeferredComputation;
import org.renjin.repackaged.guava.collect.Lists;
import org.renjin.sexp.AttributeMap;
import org.renjin.sexp.ComplexArrayVector;
import org.renjin.sexp.ComplexVector;
import org.renjin.sexp.DoubleVector;
import org.renjin.sexp.IntVector;
import org.renjin.sexp.Logical;
import org.renjin.sexp.LogicalVector;
import org.renjin.sexp.RawVector;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.StringVector;
import org.renjin.sexp.Vector;

public class DeferredVectorBuilder {
    public static final int LENGTH_THRESHOLD = 300;
    private final JExpression contextArgument;
    private JCodeModel codeModel;
    private PrimitiveModel primitive;
    private JvmMethod overload;
    private int arity;
    private JDefinedClass vectorClass;
    private VectorType type;
    private List<DeferredArgument> arguments = Lists.newArrayList();
    private JFieldVar lengthField;

    public DeferredVectorBuilder(JCodeModel codeModel, JExpression contextArgument, PrimitiveModel primitive2, JvmMethod overload) {
        this.codeModel = codeModel;
        this.primitive = primitive2;
        this.overload = overload;
        this.arity = overload.getPositionalFormals().size();
        this.contextArgument = contextArgument;
        if (overload.getReturnType().equals(Double.TYPE)) {
            this.type = VectorType.DOUBLE;
        } else if (overload.getReturnType().equals(Boolean.TYPE)) {
            this.type = VectorType.LOGICAL;
        } else if (overload.getReturnType().equals(Logical.class)) {
            this.type = VectorType.LOGICAL;
        } else if (overload.getReturnType().equals(Integer.TYPE)) {
            this.type = VectorType.INTEGER;
        } else if (overload.getReturnType().equals(Complex.class)) {
            this.type = VectorType.COMPLEX;
        } else if (overload.getReturnType().equals(Byte.TYPE)) {
            this.type = VectorType.RAW;
        } else {
            throw new UnsupportedOperationException(overload.getReturnType().toString());
        }
    }

    public void buildClass() {
        try {
            this.vectorClass = this.codeModel._class(WrapperGenerator2.toFullJavaName(this.primitive.getName()) + "$deferred_" + this.typeSuffix());
        }
        catch (JClassAlreadyExistsException e) {
            throw new RuntimeException(e);
        }
        this.vectorClass._extends(this.type.baseClass);
        this.vectorClass._implements(DeferredComputation.class);
        for (int i = 0; i != this.arity; ++i) {
            this.arguments.add(new DeferredArgument(this.overload.getPositionalFormals().get(i), i));
        }
        this.lengthField = this.vectorClass.field(4, this.codeModel._ref(Integer.TYPE), "length");
        this.writeConstructor();
        this.implementAccessor();
        this.implementLength();
        this.implementAttributeSetter();
        this.implementGetOperands();
        this.implementGetComputationName();
        this.implementStaticApply();
        this.implementIsConstantAccess();
        this.implementIsDeferred();
        this.implementGetComputationDepth();
        if (this.overload.isPassNA() && this.overload.getReturnType().equals(Boolean.TYPE)) {
            this.overrideIsNaWithConstantValue();
        }
    }

    private void implementIsConstantAccess() {
        JMethod method = this.vectorClass.method(1, Boolean.TYPE, "isConstantAccessTime");
        JExpression condition = null;
        for (DeferredArgument arg : this.arguments) {
            JInvocation operandIsConstant = arg.valueField.invoke("isConstantAccessTime");
            if (condition == null) {
                condition = operandIsConstant;
                continue;
            }
            condition = condition.cand(operandIsConstant);
        }
        method.body()._return(condition);
    }

    private void implementIsDeferred() {
        JMethod method = this.vectorClass.method(1, Boolean.TYPE, "isDeferred");
        method.body()._return(JExpr.TRUE);
    }

    private void implementGetComputationDepth() {
        JMethod method = this.vectorClass.method(1, Integer.TYPE, "getComputationDepth");
        JVar depth = method.body().decl(this.codeModel._ref(Integer.TYPE), "depth", this.arguments.get(0).valueField.invoke("getComputationDepth"));
        for (int i = 1; i < this.arguments.size(); ++i) {
            method.body().assign(depth, this.codeModel.ref(Math.class).staticInvoke("max").arg(depth).arg(this.arguments.get(1).valueField.invoke("getComputationDepth")));
        }
        method.body()._return(depth.plus(JExpr.lit(1)));
    }

    private void implementGetOperands() {
        JMethod method = this.vectorClass.method(1, Vector[].class, "getOperands");
        JArray array2 = JExpr.newArray(this.codeModel.ref(Vector.class));
        for (DeferredArgument arg : this.arguments) {
            array2.add(arg.valueField);
        }
        method.body()._return(array2);
    }

    private void implementGetComputationName() {
        JMethod method = this.vectorClass.method(1, String.class, "getComputationName");
        method.body()._return(JExpr.lit(this.primitive.getName()));
    }

    private String typeSuffix() {
        StringBuilder suffix = new StringBuilder();
        for (JvmMethod.Argument formal : this.overload.getPositionalFormals()) {
            suffix.append(this.abbrev(formal.getClazz()));
        }
        return suffix.toString();
    }

    private String abbrev(Class clazz) {
        if (clazz.equals(Double.TYPE)) {
            return "d";
        }
        if (clazz.equals(Boolean.TYPE)) {
            return "b";
        }
        if (clazz.equals(String.class)) {
            return "s";
        }
        if (clazz.equals(Integer.TYPE)) {
            return "i";
        }
        if (clazz.equals(Complex.class)) {
            return "z";
        }
        if (clazz.equals(Byte.TYPE)) {
            return "r";
        }
        throw new UnsupportedOperationException(clazz.toString());
    }

    public void maybeReturn(JBlock parent2, JExpression cycleCount, List<JExpression> arguments, JExpression attributes2) {
        JExpression condition = cycleCount.gt(JExpr.lit(300));
        for (JExpression arg : arguments) {
            condition = condition.cor(arg.invoke("isDeferred"));
        }
        condition = condition.cand(cycleCount.ne(JExpr.lit(0)));
        JBlock ifBig = parent2._if(condition)._then();
        JInvocation newInvocation = JExpr._new(this.vectorClass);
        for (JExpression arg : arguments) {
            newInvocation.arg(arg);
        }
        newInvocation.arg(attributes2);
        ifBig._return(this.contextArgument.invoke("simplify").arg(newInvocation));
    }

    private void writeConstructor() {
        int i;
        JMethod ctor = this.vectorClass.constructor(1);
        ArrayList<JVar> argParams = Lists.newArrayList();
        for (i = 0; i != this.arity; ++i) {
            argParams.add(ctor.param(Vector.class, "arg" + i));
        }
        ctor.param(AttributeMap.class, "attributes");
        ctor.body().directStatement("super(attributes);");
        ctor.body().assign(this.lengthField, JExpr.lit(0));
        for (i = 0; i != this.arity; ++i) {
            ctor.body().assign(JExpr._this().ref(this.arg(i).valueField), (JExpression)argParams.get(i));
            ctor.body().assign(this.arg(i).lengthField, this.arg(i).valueField.invoke("length"));
        }
        if (this.arity == 1) {
            ctor.body().assign(this.lengthField, this.arg(0).lengthField);
        } else if (this.arity == 2) {
            ctor.body().assign(this.lengthField, this.codeModel.ref(Math.class).staticInvoke("max").arg(this.arg(0).lengthField).arg(this.arg(1).lengthField));
        }
    }

    private DeferredArgument arg(int i) {
        return this.arguments.get(i);
    }

    private void implementLength() {
        JMethod method = this.vectorClass.method(1, Integer.TYPE, "length");
        method.body()._return(this.lengthField);
    }

    private void implementStaticApply() {
        JMethod method = this.vectorClass.method(17, this.type.accessorType, "compute");
        ArrayList<JExpression> params = Lists.newArrayList();
        for (DeferredArgument argument : this.arguments) {
            JVar param = method.param(argument.accessorType(), "p" + argument.index);
            params.add(argument.convert(param));
        }
        this.returnValue(method.body(), this.buildInvocation(params));
    }

    private void implementAccessor() {
        JMethod method = this.vectorClass.method(1, this.type.accessorType, this.type.accessorName);
        JVar index = method.param(Integer.TYPE, "index");
        ArrayList<JExpression> argValues = Lists.newArrayList();
        for (DeferredArgument arg : this.arguments) {
            JVar elementIndex;
            if (this.arity == 1) {
                elementIndex = index;
            } else {
                JVar indexVar = method.body().decl(this.codeModel._ref(Integer.TYPE), "i" + arg.index);
                JConditional ifLessThan = method.body()._if(index.lt(arg.lengthField));
                ifLessThan._then().assign(indexVar, index);
                ifLessThan._else().assign(indexVar, index.mod(arg.lengthField));
                elementIndex = indexVar;
            }
            JVar argValue = method.body().decl(arg.accessorType(), "arg" + arg.index + "_i", arg.invokeAccessor(elementIndex));
            argValues.add(arg.convert(argValue));
            if (this.overload.isPassNA() || arg.type == ArgumentType.BYTE) continue;
            method.body()._if(arg.isNA(argValue))._then()._return(this.na());
        }
        this.returnValue(method.body(), this.buildInvocation(argValues));
    }

    private JInvocation buildInvocation(List<JExpression> argValues) {
        JInvocation invocation = this.codeModel.ref(this.overload.getDeclaringClass()).staticInvoke(this.overload.getName());
        for (JExpression argValue : argValues) {
            invocation.arg(argValue);
        }
        return invocation;
    }

    private JExpression na() {
        switch (this.type) {
            case DOUBLE: {
                return this.codeModel.ref(DoubleVector.class).staticRef("NA");
            }
            case LOGICAL: 
            case INTEGER: {
                return this.codeModel.ref(IntVector.class).staticRef("NA");
            }
            case COMPLEX: {
                return this.codeModel.ref(ComplexArrayVector.class).staticRef("NA");
            }
        }
        throw new UnsupportedOperationException(this.type.toString());
    }

    private void returnValue(JBlock parent2, JExpression retVal) {
        if (this.overload.getReturnType().equals(Boolean.TYPE)) {
            JConditional ifTrue = parent2._if(retVal);
            ifTrue._then()._return(JExpr.lit(1));
            ifTrue._else()._return(JExpr.lit(0));
        } else if (this.overload.getReturnType().equals(Logical.class)) {
            parent2._return(retVal.invoke("getInternalValue"));
        } else {
            parent2._return(retVal);
        }
    }

    public void overrideIsNaWithConstantValue() {
        JMethod method = this.vectorClass.method(1, Boolean.TYPE, "isElementNA");
        method.param(Integer.TYPE, "index");
        method.body()._return(JExpr.FALSE);
    }

    private void implementAttributeSetter() {
        JMethod method = this.vectorClass.method(1, SEXP.class, "cloneWithNewAttributes");
        JVar attributes2 = method.param(AttributeMap.class, "attributes");
        JInvocation newInvocation = JExpr._new(this.vectorClass);
        for (DeferredArgument arg : this.arguments) {
            newInvocation.arg(arg.valueField);
        }
        newInvocation.arg(attributes2);
        method.body()._return(newInvocation);
    }

    private static enum ArgumentType {
        DOUBLE(Double.TYPE, "getElementAsDouble"){

            @Override
            public JExpression isNa(JCodeModel codeModel, JExpression expr) {
                return codeModel.ref(DoubleVector.class).staticInvoke("isNA").arg(expr);
            }
        }
        ,
        INTEGER(Integer.TYPE, "getElementAsInt"){

            @Override
            public JExpression isNa(JCodeModel codeModel, JExpression expr) {
                return codeModel.ref(IntVector.class).staticInvoke("isNA").arg(expr);
            }
        }
        ,
        BOOLEAN(Boolean.TYPE, "getElementAsRawLogical"){

            @Override
            public JExpression convertToArg(JExpression expr) {
                return expr.ne(JExpr.lit(0));
            }

            @Override
            public Class accessorType() {
                return Integer.TYPE;
            }

            @Override
            public JExpression isNa(JCodeModel codeModel, JExpression expr) {
                return codeModel.ref(IntVector.class).staticInvoke("isNA").arg(expr);
            }
        }
        ,
        STRING(String.class, "getElementAsString"){

            @Override
            public JExpression isNa(JCodeModel codeModel, JExpression expr) {
                return codeModel.ref(StringVector.class).staticInvoke("isNA").arg(expr);
            }
        }
        ,
        COMPLEX(Complex.class, "getElementAsComplex"){

            @Override
            public JExpression isNa(JCodeModel codeModel, JExpression expr) {
                return codeModel.ref(ComplexVector.class).staticInvoke("isNA").arg(expr);
            }
        }
        ,
        BYTE(Byte.TYPE, "getElementAsByte"){

            @Override
            public JExpression isNa(JCodeModel codeModel, JExpression expr) {
                return JExpr.lit(false);
            }
        };

        private Class clazz;
        private String accessorName;

        private ArgumentType(Class clazz, String accessorName) {
            this.clazz = clazz;
            this.accessorName = accessorName;
        }

        public JExpression convertToArg(JExpression expr) {
            return expr;
        }

        public Class accessorType() {
            return this.clazz;
        }

        public abstract JExpression isNa(JCodeModel var1, JExpression var2);
    }

    private static enum VectorType {
        DOUBLE(DoubleVector.class, "getElementAsDouble", Double.TYPE),
        LOGICAL(LogicalVector.class, "getElementAsRawLogical", Integer.TYPE),
        INTEGER(IntVector.class, "getElementAsInt", Integer.TYPE),
        COMPLEX(ComplexVector.class, "getElementAsComplex", Complex.class),
        RAW(RawVector.class, "getElementAsByte", Byte.TYPE);

        private Class baseClass;
        private String accessorName;
        private Class accessorType;

        private VectorType(Class baseClass, String accessorName, Class accessorType) {
            this.baseClass = baseClass;
            this.accessorName = accessorName;
            this.accessorType = accessorType;
        }
    }

    private class DeferredArgument {
        private JvmMethod.Argument model;
        private int index;
        private JFieldVar valueField;
        private JFieldVar lengthField;
        private ArgumentType type;

        private DeferredArgument(JvmMethod.Argument model2, int index) {
            this.model = model2;
            this.index = index;
            this.valueField = DeferredVectorBuilder.this.vectorClass.field(12, Vector.class, "arg" + index);
            this.lengthField = DeferredVectorBuilder.this.vectorClass.field(12, Integer.TYPE, "argLength" + index);
            if (model2.getClazz().equals(Double.TYPE)) {
                this.type = ArgumentType.DOUBLE;
            } else if (model2.getClazz().equals(Boolean.TYPE)) {
                this.type = ArgumentType.BOOLEAN;
            } else if (model2.getClazz().equals(Integer.TYPE)) {
                this.type = ArgumentType.INTEGER;
            } else if (model2.getClazz().equals(String.class)) {
                this.type = ArgumentType.STRING;
            } else if (model2.getClazz().equals(Complex.class)) {
                this.type = ArgumentType.COMPLEX;
            } else if (model2.getClazz().equals(Byte.TYPE)) {
                this.type = ArgumentType.BYTE;
            } else {
                throw new UnsupportedOperationException(model2.getClazz().toString());
            }
        }

        public JType type() {
            return DeferredVectorBuilder.this.codeModel._ref(this.model.getClazz());
        }

        public JExpression invokeAccessor(JExpression elementIndex) {
            return this.valueField.invoke(this.type.accessorName).arg(elementIndex);
        }

        public JType accessorType() {
            return DeferredVectorBuilder.this.codeModel._ref(this.type.accessorType());
        }

        public JExpression isNA(JExpression expr) {
            return this.type.isNa(DeferredVectorBuilder.this.codeModel, expr);
        }

        public JExpression convert(JExpression argValue) {
            return this.type.convertToArg(argValue);
        }
    }
}

