/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.invoke.codegen;

import org.renjin.eval.Context;
import org.renjin.invoke.codegen.ArgumentException;
import org.renjin.primitives.Deparse;
import org.renjin.sexp.DoubleArrayVector;
import org.renjin.sexp.DoubleVector;
import org.renjin.sexp.Environment;
import org.renjin.sexp.ExternalPtr;
import org.renjin.sexp.FunctionCall;
import org.renjin.sexp.IntArrayVector;
import org.renjin.sexp.IntVector;
import org.renjin.sexp.Logical;
import org.renjin.sexp.LogicalArrayVector;
import org.renjin.sexp.LogicalVector;
import org.renjin.sexp.Null;
import org.renjin.sexp.PairList;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.StringArrayVector;
import org.renjin.sexp.StringVector;
import org.renjin.sexp.Symbol;
import org.renjin.sexp.Symbols;
import org.renjin.sexp.Vector;

public class WrapperRuntime {
    public static String convertToString(SEXP exp2) {
        if (exp2 == Null.INSTANCE) {
            return null;
        }
        Vector vector2 = WrapperRuntime.checkedSubClassAndAssertScalar(exp2);
        return vector2.getElementAsString(0);
    }

    public static int convertToInt(SEXP exp2) {
        if (exp2 instanceof DoubleVector || exp2 instanceof IntVector || exp2 instanceof LogicalVector) {
            return ((Vector)exp2).getElementAsInt(0);
        }
        throw new ArgumentException("expected int");
    }

    public static SEXP argumentValue(PairList args2) {
        if (!(args2 instanceof PairList.Node)) {
            throw new ArgumentException("too few arguments");
        }
        return ((PairList.Node)args2).getValue();
    }

    private Integer convertToInteger(SEXP exp2) {
        if (exp2 == Null.INSTANCE) {
            return null;
        }
        Vector vector2 = WrapperRuntime.checkedSubClassAndAssertScalar(exp2);
        if (vector2.isElementNA(0)) {
            return null;
        }
        return vector2.getElementAsInt(0);
    }

    public static Vector invokeAsCharacter(Context context, Environment rho, SEXP provided) {
        if (provided == Null.INSTANCE) {
            return Null.INSTANCE;
        }
        provided = provided.force(context);
        return (Vector)context.evaluate(FunctionCall.newCall(Symbols.AS_CHARACTER, provided), rho);
    }

    public static boolean convertToBooleanPrimitive(SEXP exp2) {
        if (exp2.length() == 0) {
            return false;
        }
        return exp2.asLogical() == Logical.TRUE;
    }

    public static Vector convertToVector(SEXP exp2) {
        if (exp2 instanceof Vector) {
            return (Vector)exp2;
        }
        if (exp2 instanceof Symbol) {
            return new StringArrayVector(((Symbol)exp2).getPrintName());
        }
        if (exp2 instanceof FunctionCall) {
            return new StringArrayVector(Deparse.deparseExp(null, exp2));
        }
        throw new ArgumentException("expected vector");
    }

    public static double convertToDoublePrimitive(SEXP exp2) {
        Vector vector2 = WrapperRuntime.checkedSubClassAndAssertScalar(exp2);
        return vector2.getElementAsDouble(0);
    }

    public static double convertToRawPrimitive(SEXP exp2) {
        Vector vector2 = WrapperRuntime.checkedSubClassAndAssertScalar(exp2);
        return vector2.getElementAsByte(0);
    }

    public static float convertToFloatPrimitive(SEXP exp2) {
        Vector vector2 = WrapperRuntime.checkedSubClassAndAssertScalar(exp2);
        return (float)vector2.getElementAsDouble(0);
    }

    private static Vector checkedSubClassAndAssertScalar(SEXP exp2) {
        if (exp2.length() != 1) {
            throw new ArgumentException("expected vector of length 1");
        }
        if (!(exp2 instanceof Vector)) {
            throw new ArgumentException("expected vector of length 1");
        }
        return (Vector)exp2;
    }

    public static <T> T unwrapExternal(SEXP exp2) {
        try {
            ExternalPtr external = (ExternalPtr)exp2;
            return external.getInstance();
        }
        catch (ClassCastException e) {
            throw new ArgumentException("expected external object");
        }
    }

    public static SEXP wrapResult(int i) {
        return new IntArrayVector(i);
    }

    public static SEXP wrapResult(Integer i) {
        return new IntArrayVector(i == null ? Integer.MIN_VALUE : i);
    }

    public static SEXP wrapResult(String s) {
        return StringVector.valueOf(s);
    }

    public static SEXP wrapResult(boolean b) {
        return new LogicalArrayVector(b);
    }

    public static SEXP wrapResult(float f) {
        return new DoubleArrayVector(f);
    }

    public static SEXP wrapResult(double d) {
        return new DoubleArrayVector(d);
    }

    public static SEXP wrapResult(long result) {
        return new DoubleArrayVector(result);
    }

    public static SEXP wrapResult(int[] result) {
        return new IntArrayVector(result);
    }

    public static SEXP wrapResult(Logical result) {
        return new LogicalArrayVector(result);
    }
}

