/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.invoke.reflection;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.renjin.eval.Context;
import org.renjin.invoke.annotations.Current;
import org.renjin.invoke.reflection.converters.Converter;
import org.renjin.invoke.reflection.converters.Converters;
import org.renjin.sexp.SEXP;

public abstract class AbstractOverload {
    private int nargs;
    private int baseArgCount;
    private boolean varArgs;
    private int firstArg = 0;
    private boolean context;
    private Converter[] argumentConverters;
    private Converter varArgConverter;
    private Converter varArgArrayConverter;
    private Class varArgElementClass;

    public AbstractOverload(Class[] parameterTypes, Annotation[][] annotations, boolean varArgs) {
        this.nargs = parameterTypes.length;
        this.varArgs = varArgs;
        this.baseArgCount = varArgs ? this.nargs - 1 : this.nargs;
        if (this.firstArgIsContext(annotations)) {
            this.firstArg = 1;
            --this.baseArgCount;
            this.context = true;
        }
        this.argumentConverters = new Converter[this.baseArgCount];
        for (int i = 0; i != this.baseArgCount; ++i) {
            this.argumentConverters[i] = Converters.get(parameterTypes[this.firstArg + i]);
        }
        if (varArgs) {
            this.varArgArrayConverter = Converters.get(parameterTypes[this.nargs - 1]);
            this.varArgElementClass = parameterTypes[this.nargs - 1].getComponentType();
            this.varArgConverter = Converters.get(this.varArgElementClass);
        }
    }

    private boolean firstArgIsContext(Annotation[][] annotations) {
        if (annotations.length == 0) {
            return false;
        }
        for (int i = 0; i != annotations[0].length; ++i) {
            if (!(annotations[0][i] instanceof Current)) continue;
            return true;
        }
        return false;
    }

    protected final Object[] convertArguments(Context context, List<SEXP> args2) {
        Object[] converted = new Object[this.nargs];
        if (this.context) {
            converted[0] = context;
        }
        for (int i = 0; i != this.baseArgCount; ++i) {
            converted[i + this.firstArg] = this.argumentConverters[i].convertToJava(args2.get(i));
        }
        if (this.varArgs) {
            int nVarArgs = args2.size() - this.baseArgCount;
            if (nVarArgs == 1 && this.varArgArrayConverter.acceptsSEXP(args2.get(this.baseArgCount))) {
                converted[this.nargs - 1] = this.varArgArrayConverter.convertToJava(args2.get(this.baseArgCount));
            } else {
                Object extra = Array.newInstance(this.varArgElementClass, args2.size() - this.baseArgCount);
                int i = 0;
                while (i + this.baseArgCount < args2.size()) {
                    Array.set(extra, i, this.varArgConverter.convertToJava(args2.get(i + this.baseArgCount)));
                    ++i;
                }
                converted[this.nargs - 1] = extra;
            }
        }
        return converted;
    }

    public final int getArgCount() {
        return this.nargs;
    }

    public boolean isVarArgs() {
        return this.varArgs;
    }

    public boolean accept(List<SEXP> args2) {
        int i;
        if (args2.size() < this.baseArgCount) {
            return false;
        }
        if (!this.varArgs && args2.size() > this.baseArgCount) {
            return false;
        }
        for (i = 0; i != this.baseArgCount; ++i) {
            if (this.argumentConverters[i].acceptsSEXP(args2.get(i))) continue;
            return false;
        }
        for (i = this.baseArgCount; i < args2.size(); ++i) {
            if (this.varArgConverter.acceptsSEXP(args2.get(i))) continue;
            return false;
        }
        return true;
    }

    public static void sortOverloads(List<? extends AbstractOverload> overloads) {
        Collections.sort(overloads, new Comparator<AbstractOverload>(){

            @Override
            public int compare(AbstractOverload o1, AbstractOverload o2) {
                if (o1.baseArgCount != o2.baseArgCount) {
                    return o1.baseArgCount - o2.baseArgCount;
                }
                for (int i = 0; i != o1.baseArgCount; ++i) {
                    int cmp = o1.argumentConverters[i].getSpecificity() - o2.argumentConverters[i].getSpecificity();
                    if (cmp == 0) continue;
                    return cmp;
                }
                if (!o1.varArgs && !o2.varArgs) {
                    return 0;
                }
                if (o1.varArgs && !o2.varArgs) {
                    return 1;
                }
                if (!o1.varArgs && o2.varArgs) {
                    return -1;
                }
                return o1.varArgConverter.getSpecificity() - o2.varArgConverter.getSpecificity();
            }
        });
    }
}

