/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.nmath;

import org.renjin.gcc.runtime.Builtins;
import org.renjin.gcc.runtime.Mathlib;
import org.renjin.nmath.dnorm;
import org.renjin.nmath.dt;
import org.renjin.nmath.lgamma;
import org.renjin.nmath.pnt;

public class dnt {
    private dnt() {
    }

    public static double dnt(double d, double d2, double d3, int n) {
        double d4;
        if (Builtins.__isnan(d) != 0 || Builtins.__isnan(d2) != 0) {
            d4 = d + d2;
        } else if (d2 <= 0.0) {
            d4 = 0.0 / 0.0;
        } else if (d3 == 0.0) {
            d4 = dt.dt(d, d2, n);
        } else if (Builtins.__finite(d) == 0) {
            double iftmp$0 = n != 0 ? -1.0 / 0.0 : 0.0;
            d4 = iftmp$0;
        } else if (Builtins.__finite(d2) == 0 || d2 > 1.0E8) {
            d4 = dnorm.dnorm4(d, d3, 1.0, n);
        } else {
            double u;
            double d5 = Math.abs(d);
            double d6 = Mathlib.sqrt(d2 * 2.220446049250313E-16);
            if (d5 > d6) {
                double d7 = Math.log(d2);
                double d8 = Math.log(Math.abs(d));
                double d9 = d7 - d8;
                double d10 = d2 + 2.0;
                double d11 = pnt.pnt(Mathlib.sqrt((d2 + 2.0) / d2) * d, d10, d3, 1, 0);
                double d12 = pnt.pnt(d, d2, d3, 1, 0);
                double d13 = Math.log(Math.abs(d11 - d12));
                u = d9 + d13;
            } else {
                double d14 = lgamma.lgammafn((d2 + 1.0) / 2.0);
                double d15 = lgamma.lgammafn(d2 / 2.0);
                double d16 = d14 - d15;
                double d17 = Math.log(d2);
                double d18 = d3;
                double d19 = d18 * d18;
                double d20 = (d17 + d19) * 0.5 + 0.5723649429247001;
                u = d16 - d20;
            }
            double iftmp$1 = n == 0 ? Math.exp(u) : u;
            d4 = iftmp$1;
        }
        return d4;
    }
}

