/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives;

import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayDeque;
import java.util.ArrayList;
import org.renjin.eval.Context;
import org.renjin.eval.EvalException;
import org.renjin.invoke.annotations.Builtin;
import org.renjin.invoke.annotations.Current;
import org.renjin.invoke.annotations.Internal;
import org.renjin.invoke.annotations.Unevaluated;
import org.renjin.parser.ParseException;
import org.renjin.parser.RParser;
import org.renjin.primitives.Contexts;
import org.renjin.primitives.Deparse;
import org.renjin.primitives.Primitives;
import org.renjin.primitives.io.connections.Connection;
import org.renjin.primitives.io.connections.Connections;
import org.renjin.primitives.special.ReturnException;
import org.renjin.repackaged.guava.collect.Lists;
import org.renjin.repackaged.guava.io.CharSource;
import org.renjin.sexp.AtomicVector;
import org.renjin.sexp.DoubleVector;
import org.renjin.sexp.Environment;
import org.renjin.sexp.ExpressionVector;
import org.renjin.sexp.Function;
import org.renjin.sexp.FunctionCall;
import org.renjin.sexp.IntArrayVector;
import org.renjin.sexp.IntVector;
import org.renjin.sexp.ListVector;
import org.renjin.sexp.NamedValue;
import org.renjin.sexp.Null;
import org.renjin.sexp.PairList;
import org.renjin.sexp.PrimitiveFunction;
import org.renjin.sexp.Promise;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.StringVector;
import org.renjin.sexp.Symbol;
import org.renjin.sexp.Symbols;
import org.renjin.sexp.Vector;

public class Evaluation {
    @Internal
    public static SEXP assign(@Current Context context, String name, SEXP value, Environment environ, boolean inherits2) {
        Symbol symbol2 = Symbol.get(name);
        if (!inherits2) {
            environ.setVariable(symbol2, value);
        } else {
            while (environ != Environment.EMPTY && !environ.hasVariable(symbol2)) {
                environ = environ.getParent();
            }
            if (environ == Environment.EMPTY) {
                context.getGlobalEnvironment().setVariable(symbol2, value);
            } else {
                environ.setVariable(symbol2, value);
            }
        }
        context.setInvisibleFlag();
        return value;
    }

    @Internal
    public static void delayedAssign(String x, SEXP expr, Environment evalEnv, Environment assignEnv) {
        assignEnv.setVariable(Symbol.get(x), (SEXP)Promise.repromise(evalEnv, expr));
    }

    @Builtin(value="on.exit")
    public static void onExit(@Current Context context, @Unevaluated SEXP exp2, boolean add) {
        if (add) {
            context.addOnExit(exp2);
        } else {
            context.setOnExit(exp2);
        }
    }

    @Internal
    public static ListVector lapply(@Current Context context, @Current Environment rho, Vector vector2, Function function2) {
        ListVector.Builder builder = ListVector.newBuilder();
        for (int i = 0; i != vector2.length(); ++i) {
            FunctionCall getElementCall = FunctionCall.newCall(Symbol.get("[["), vector2, new IntArrayVector(i + 1));
            FunctionCall applyFunctionCall = new FunctionCall(function2, new PairList.Node(getElementCall, new PairList.Node(Symbols.ELLIPSES, Null.INSTANCE)));
            builder.add(context.evaluate(applyFunctionCall, rho));
        }
        builder.setAttribute(Symbols.NAMES, (SEXP)vector2.getNames());
        return builder.build();
    }

    @Internal
    public static Vector vapply(@Current Context context, @Current Environment rho, Vector vector2, Function function2, Vector funValue, boolean useNames) {
        PairList extraArgs = (PairList)rho.getVariable(Symbols.ELLIPSES);
        Vector.Builder result = funValue.getVectorType().newBuilderWithInitialCapacity(vector2.length());
        for (int i = 0; i != vector2.length(); ++i) {
            PairList.Builder args2 = new PairList.Builder();
            FunctionCall getCall = FunctionCall.newCall(Symbol.get("[["), vector2, new IntArrayVector(i + 1));
            args2.add(getCall);
            args2.addAll(extraArgs);
            FunctionCall call2 = new FunctionCall(function2, args2.build());
            SEXP x = context.evaluate(call2);
            if (!(x instanceof Vector) || x.length() != funValue.length() || ((Vector)x).getVectorType().isWiderThan(funValue)) {
                throw new EvalException("values must be type '%s',\n but %s result is type '%s'", funValue.getTypeName(), Deparse.deparseExp(context, call2), x.getTypeName());
            }
            for (int j = 0; j != funValue.length(); ++j) {
                result.addFrom(x, j);
            }
        }
        if (useNames) {
            result.setAttribute(Symbols.NAMES, vector2.getAttribute(Symbols.NAMES));
        }
        if (funValue.length() != 1) {
            result.setDim(funValue.length(), vector2.length());
        }
        return result.build();
    }

    @Internal
    public static ListVector mapply(@Current Context context, SEXP f, SEXP varyingArgs, Vector constantArgs, Environment rho) {
        int longest = 0;
        int[] lengths = new int[varyingArgs.length()];
        for (int i = 0; i < varyingArgs.length(); ++i) {
            lengths[i] = varyingArgs.getElementAsSEXP(i).length();
            if (lengths[i] <= longest) continue;
            longest = lengths[i];
        }
        ListVector.Builder result = ListVector.newBuilder();
        Symbol doubleBracket = Symbol.get("[[");
        for (int i = 0; i < longest; ++i) {
            PairList.Builder args2 = new PairList.Builder();
            for (int j = 0; j != varyingArgs.length(); ++j) {
                Object arg = varyingArgs.getElementAsSEXP(j);
                args2.add(varyingArgs.getName(j), (SEXP)FunctionCall.newCall(doubleBracket, new SEXP[]{arg, IntVector.valueOf(i % arg.length() + 1)}));
            }
            if (constantArgs.length() > 0) {
                args2.addAll((ListVector)constantArgs);
            }
            result.add(context.evaluate(new FunctionCall(f, args2.build()), rho));
        }
        return result.build();
    }

    @Builtin(value="return")
    public static SEXP doReturn(@Current Environment rho, SEXP value) {
        throw new ReturnException(rho, value);
    }

    @Internal(value="do.call")
    public static SEXP doCall(@Current Context context, Function what, ListVector arguments, Environment environment2) {
        PairList argumentPairList = new PairList.Builder().addAll(arguments).build();
        FunctionCall call2 = new FunctionCall(what, argumentPairList);
        return context.evaluate(call2, environment2);
    }

    @Internal(value="do.call")
    public static SEXP doCall(@Current Context context, String what, ListVector arguments, Environment environment2) {
        Function function2 = environment2.findFunction(context, Symbol.get(what));
        if (function2 == null) {
            throw new EvalException("Could not find function '%s'", what);
        }
        return Evaluation.doCall(context, function2, arguments, environment2);
    }

    @Internal
    public static SEXP eval(@Current Context context, SEXP expression2, SEXP environment2, SEXP enclosing) {
        SEXP result;
        Environment rho;
        if (environment2 instanceof Environment) {
            rho = (Environment)environment2;
        } else if (environment2 instanceof DoubleVector || environment2 instanceof IntVector) {
            int which2 = ((AtomicVector)environment2).getElementAsInt(0);
            if (which2 < 0) {
                ++which2;
            }
            rho = Contexts.sysFrame(context, which2);
        } else {
            if (environment2 == Null.INSTANCE) {
                environment2 = ListVector.EMPTY;
            }
            Environment parent2 = enclosing == Null.INSTANCE ? context.getBaseEnvironment() : (Environment)EvalException.checkedCast(enclosing);
            rho = Environment.createChildEnvironment(parent2);
            if (environment2 instanceof ListVector) {
                for (NamedValue namedValue : ((ListVector)environment2).namedValues()) {
                    if (StringVector.isNA(namedValue.getName())) continue;
                    rho.setVariable(Symbol.get(namedValue.getName()), namedValue.getValue());
                }
            } else {
                throw new EvalException("invalid 'environ' argument: " + environment2, new Object[0]);
            }
        }
        Context evalContext = context.beginEvalContext(rho);
        try {
            result = evalContext.evaluate(expression2, rho);
        }
        catch (ReturnException e) {
            if (e.getEnvironment() != rho) {
                throw e;
            }
            result = e.getValue();
        }
        evalContext.exit();
        return result;
    }

    @Internal(value="eval.with.vis")
    public static SEXP evalWithVis(@Current Context context, SEXP expression2, SEXP environment2, SEXP enclosing) {
        SEXP result = Evaluation.eval(context, expression2, environment2, enclosing);
        ListVector.NamedBuilder list2 = new ListVector.NamedBuilder();
        list2.add("value", result);
        list2.add("visible", context.getSession().isInvisible());
        return list2.build();
    }

    @Internal(value="withVisible")
    public static ListVector withVisible(@Current Context context, SEXP expression2) {
        ListVector.NamedBuilder list2 = new ListVector.NamedBuilder();
        list2.add("value", expression2);
        list2.add("visible", !context.getSession().isInvisible());
        return list2.build();
    }

    @Builtin
    public static SEXP quote(@Unevaluated SEXP exp2) {
        return exp2;
    }

    @Builtin
    public static boolean missing(@Current Context context, @Current Environment rho, @Unevaluated Symbol symbol2) {
        if (symbol2.isVarArgReference()) {
            return Evaluation.isVarArgMissing(rho, symbol2.getVarArgReferenceIndex());
        }
        SEXP value = rho.findVariable(symbol2);
        if (value == Symbol.UNBOUND_VALUE) {
            throw new EvalException("'missing' can only be used for arguments", new Object[0]);
        }
        if (value == Symbol.MISSING_ARG) {
            return true;
        }
        if (Evaluation.isDefaultValue(value)) {
            return true;
        }
        return Evaluation.isPromisedMissingArg(value, new ArrayDeque<Promise>());
    }

    private static boolean isVarArgMissing(Environment rho, int varArgReferenceIndex) {
        SEXP ellipses = rho.findVariable(Symbols.ELLIPSES);
        if (ellipses == Symbol.UNBOUND_VALUE) {
            throw new EvalException("This function does not have a ... argument", new Object[0]);
        }
        if (ellipses.length() < varArgReferenceIndex) {
            return true;
        }
        Object value = ellipses.getElementAsSEXP(varArgReferenceIndex - 1);
        return value == Symbol.MISSING_ARG || Evaluation.isPromisedMissingArg(value, new ArrayDeque<Promise>());
    }

    private static boolean isDefaultValue(SEXP exp2) {
        Promise promise;
        return exp2 instanceof Promise && (promise = (Promise)exp2).isMissingArgument();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isPromisedMissingArg(SEXP exp2, ArrayDeque<Promise> stack) {
        Promise promise;
        if (exp2 instanceof Promise && (promise = (Promise)exp2).getExpression() instanceof Symbol) {
            if (stack.contains(promise)) {
                return true;
            }
            stack.push(promise);
            try {
                Symbol argumentName = (Symbol)promise.getExpression();
                SEXP argumentValue = promise.getEnvironment().getVariable(argumentName);
                if (argumentValue == Symbol.MISSING_ARG) {
                    boolean bl = true;
                    return bl;
                }
                if (Evaluation.isPromisedMissingArg(argumentValue, stack)) {
                    boolean bl = true;
                    return bl;
                }
            }
            finally {
                stack.pop();
            }
        }
        return false;
    }

    @Internal
    public static ExpressionVector parse(@Current Context context, SEXP file2, SEXP maxExpressions, Vector text, String prompt, SEXP sourceFile, String encoding) throws IOException {
        try {
            if (text != Null.INSTANCE) {
                ArrayList<CharSource> lines = Lists.newArrayList();
                CharSource newLine = CharSource.wrap("\n");
                for (int i = 0; i != text.length(); ++i) {
                    lines.add(CharSource.wrap(text.getElementAsString(i)));
                    lines.add(newLine);
                }
                return RParser.parseAllSource(CharSource.concat(lines).openStream(), sourceFile);
            }
            if (file2.inherits("connection")) {
                Connection conn = Connections.getConnection(context, file2);
                InputStreamReader reader = new InputStreamReader(conn.getInputStream());
                return RParser.parseAllSource(reader, sourceFile);
            }
            throw new EvalException("unsupported parsing source", new Object[0]);
        }
        catch (ParseException e) {
            throw new EvalException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new EvalException("I/O Exception occurred during parse: " + e.getMessage(), new Object[0]);
        }
    }

    @Builtin
    public static int nargs(@Current Context context) {
        return context.getArguments().length();
    }

    @Builtin(value=".Primitive")
    public static PrimitiveFunction getPrimitive(String name) {
        PrimitiveFunction fn = Primitives.getBuiltin(Symbol.get(name));
        if (fn == null) {
            throw new EvalException("No such primitive function", new Object[0]);
        }
        return fn;
    }

    @Internal
    public static void remove(StringVector names2, Environment envir, boolean inherits2) {
        if (inherits2) {
            throw new EvalException("remove(inherits=TRUE) is not yet implemented", new Object[0]);
        }
        for (String name : names2) {
            envir.remove(Symbol.get(name));
        }
    }
}

