/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives;

import org.renjin.sexp.Vector;

public class Indexes {
    public static int arrayIndexToVectorIndex(int[] arrayIndex, int[] dim2) {
        int vectorIndex = 0;
        int offset = 1;
        for (int i = 0; i != dim2.length; ++i) {
            vectorIndex += arrayIndex[i] * offset;
            offset *= dim2[i];
        }
        return vectorIndex;
    }

    public static int matrixIndexToVectorIndex(int row2, int col2, int nrows, int ncols) {
        return row2 + col2 * nrows;
    }

    public static int vectorIndexToRow(int vectorIndex, int nrows) {
        return vectorIndex % nrows;
    }

    public static Integer vectorIndexToCol(int vectorIndex, int numRows, int numCols) {
        int row2 = vectorIndex % numRows;
        vectorIndex = (vectorIndex - row2) / numRows;
        return vectorIndex % numCols;
    }

    public static void vectorIndexToArrayIndex(int vectorIndex, int[] arrayIndex, int[] dim2) {
        for (int i = 0; i != dim2.length; ++i) {
            arrayIndex[i] = vectorIndex % dim2[i];
            vectorIndex = (vectorIndex - arrayIndex[i]) / dim2[i];
        }
    }

    public static int[] vectorIndexToArrayIndex(int vectorIndex, int[] dim2) {
        int[] index = new int[dim2.length];
        Indexes.vectorIndexToArrayIndex(vectorIndex, index, dim2);
        return index;
    }

    public static boolean incrementArrayIndex(int[] arrayIndex, int[] dim2) {
        for (int i = 0; i != arrayIndex.length; ++i) {
            if (arrayIndex[i] + 1 >= dim2[i]) continue;
            arrayIndex[i] = arrayIndex[i] + 1;
            for (int j = 0; j != i; ++j) {
                arrayIndex[j] = 0;
            }
            return true;
        }
        return false;
    }

    public static Vector permute(Vector vector2, int[] permutation) {
        Vector.Builder permuted = vector2.newBuilderWithInitialSize(vector2.length());
        for (int i = 0; i != vector2.length(); ++i) {
            permuted.setFrom(i, vector2, permutation[i]);
        }
        return permuted.build();
    }

    public static int[] permute(int[] values, int[] permutation) {
        int[] copy2 = new int[values.length];
        for (int i = 0; i != values.length; ++i) {
            copy2[i] = values[permutation[i]];
        }
        return copy2;
    }

    public static int[] unpermute(int[] values, int[] permutation) {
        int[] copy2 = new int[values.length];
        for (int i = 0; i != values.length; ++i) {
            copy2[permutation[i]] = values[i];
        }
        return copy2;
    }
}

