/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives.combine;

import org.renjin.primitives.combine.CombinedBuilder;
import org.renjin.primitives.combine.CombinedNames;
import org.renjin.sexp.AtomicVector;
import org.renjin.sexp.ExpressionVector;
import org.renjin.sexp.FunctionCall;
import org.renjin.sexp.ListVector;
import org.renjin.sexp.PairList;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.StringVector;
import org.renjin.sexp.Vector;

class Combiner {
    private boolean recursive;
    private CombinedBuilder builder;

    public Combiner(boolean recursive2, CombinedBuilder builder) {
        this.recursive = recursive2;
        this.builder = builder;
    }

    public Combiner add(ListVector list2) {
        return this.add("", list2);
    }

    public Combiner add(String parentPrefix, ListVector list2) {
        StringVector names2 = CombinedNames.combine(parentPrefix, list2);
        for (int i = 0; i < list2.length(); ++i) {
            String name = names2.getElementAsString(i);
            SEXP value = list2.getElementAsSEXP(i);
            this.addElement(name, value);
        }
        return this;
    }

    private void addElement(String prefix, SEXP value) {
        if (value instanceof FunctionCall) {
            this.builder.add(prefix, value);
        } else if (value instanceof AtomicVector || value instanceof ExpressionVector) {
            this.builder.addElements(prefix, (Vector)value);
        } else if (value instanceof ListVector) {
            if (this.recursive) {
                this.add(prefix, (ListVector)value);
            } else {
                this.builder.addElements(prefix, (ListVector)value);
            }
        } else if (value instanceof PairList.Node) {
            if (this.recursive) {
                this.add(prefix, ((PairList.Node)value).toVector());
            } else {
                this.builder.addElements(prefix, ((PairList)value).toVector());
            }
        } else {
            this.builder.add(prefix, value);
        }
    }

    public Vector build() {
        return this.builder.build();
    }
}

