/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives.combine;

import org.renjin.primitives.combine.CombinedBuilder;
import org.renjin.primitives.combine.CombinedNames;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.StringVector;
import org.renjin.sexp.Symbols;
import org.renjin.sexp.Vector;

class MaterializedBuilder
implements CombinedBuilder {
    private Vector.Builder vector;
    private StringVector.Builder names = new StringVector.Builder();
    private boolean haveNames = false;
    private boolean useNames = false;

    MaterializedBuilder(Vector.Type resultType) {
        this.vector = resultType.newBuilder();
    }

    @Override
    public CombinedBuilder useNames(boolean useNames) {
        this.useNames = useNames;
        return this;
    }

    @Override
    public void add(String prefix, SEXP sexp2) {
        this.vector.add(sexp2);
        this.addName(prefix);
    }

    @Override
    public void addElements(String prefix, Vector value) {
        StringVector elementNames = CombinedNames.combine(prefix, value);
        if (this.useNames && CombinedNames.hasNames(prefix, value)) {
            this.haveNames = true;
        }
        for (int i = 0; i != value.length(); ++i) {
            this.vector.addFrom(value, i);
            if (!this.useNames) continue;
            this.names.add(elementNames.getElementAsString(i));
        }
    }

    @Override
    public Vector build() {
        if (this.haveNames) {
            this.vector.setAttribute(Symbols.NAMES, (SEXP)this.names.build());
        }
        return this.vector.build();
    }

    private void addName(String name) {
        if (StringVector.isNA(name) || name.length() > 0) {
            this.haveNames = true;
        }
        this.names.add(name);
    }
}

