/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives.combine;

import org.renjin.primitives.combine.BindArgument;
import org.renjin.sexp.AtomicVector;
import org.renjin.sexp.IntArrayVector;
import org.renjin.sexp.ListVector;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.Symbols;
import org.renjin.sexp.Vector;

class Matrix2dBuilder {
    private final Vector.Builder builder;
    private final int rows;
    private final int cols;
    private int count = 0;

    public Matrix2dBuilder(Vector.Builder builder, int rows, int cols) {
        this.builder = builder;
        this.rows = rows;
        this.cols = cols;
    }

    public void addFrom(BindArgument argument, int rowIndex, int colIndex) {
        int recycledColIndex = colIndex % argument.getCols();
        int recycledRowIndex = rowIndex % argument.getRows();
        this.builder.setFrom(this.count, argument.getVector(), recycledColIndex * argument.getRows() + recycledRowIndex);
        ++this.count;
    }

    public void setDimNames(AtomicVector rowNames, AtomicVector colNames) {
        this.builder.setAttribute(Symbols.DIMNAMES, (SEXP)new ListVector(rowNames, colNames));
    }

    public Vector build() {
        return this.builder.setAttribute(Symbols.DIM, (SEXP)new IntArrayVector(this.rows, this.cols)).build();
    }
}

