/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives.subset;

import org.renjin.eval.EvalException;
import org.renjin.sexp.IntVector;
import org.renjin.sexp.SEXP;

final class SubsetAssertions {
    private SubsetAssertions() {
    }

    public static void checkUniqueCount(int count) {
        if (count < 1) {
            throw new EvalException("attempt to select less than one element", new Object[0]);
        }
        if (count > 1) {
            throw new EvalException("attempt to select more than one element", new Object[0]);
        }
    }

    public static void checkBounds(SEXP source, int index) {
        if (IntVector.isNA(index) || index >= source.length()) {
            throw SubsetAssertions.outOfBounds();
        }
    }

    public static void checkUnitLength(SEXP sexp2) {
        SubsetAssertions.checkUniqueCount(sexp2.length());
    }

    public static EvalException outOfBounds() {
        return new EvalException("subscript out of bounds", new Object[0]);
    }
}

