/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives.text.regex;

import java.util.ArrayList;
import org.renjin.primitives.text.regex.RE;
import org.renjin.repackaged.guava.collect.Lists;

public class FixedRE
implements RE {
    private String pattern;
    private int matchStart;

    public FixedRE(String pattern) {
        assert (pattern != null);
        assert (pattern.length() > 0);
        this.pattern = pattern;
    }

    @Override
    public boolean match(String search2) {
        int matchStart = search2.indexOf(this.pattern);
        return matchStart != -1;
    }

    @Override
    public String subst(String substituteIn, String substitution) {
        return substituteIn.replace(this.pattern, substitution);
    }

    @Override
    public String subst(String substituteIn, String substitution, int flags) {
        if ((flags & 1) != 0) {
            int io = substituteIn.indexOf(this.pattern);
            if (io < 0) {
                return substituteIn;
            }
            return substituteIn.substring(0, io) + substitution + substituteIn.substring(io + this.pattern.length());
        }
        return substituteIn.replace(this.pattern, substitution);
    }

    @Override
    public String[] split(String s) {
        int j;
        ArrayList<String> splits = Lists.newArrayList();
        int i = 0;
        while (i < s.length() && (j = this.nextMatch(s, i)) != -1) {
            splits.add(s.substring(i, j));
            i = j + this.pattern.length();
        }
        if (i < s.length()) {
            splits.add(s.substring(i));
        }
        return splits.toArray(new String[splits.size()]);
    }

    private int nextMatch(String s, int startingIndex) {
        return s.indexOf(this.pattern, startingIndex);
    }

    @Override
    public int getGroupStart(int groupIndex) {
        if (groupIndex != 0) {
            throw new IllegalArgumentException("groupIndex out of bounds: fixed REs have no sub groups.");
        }
        return this.matchStart;
    }

    @Override
    public int getGroupEnd(int groupIndex) {
        int start = this.getGroupStart(groupIndex);
        if (start == -1) {
            return -1;
        }
        return start + this.pattern.length();
    }
}

