/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.sexp;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import org.renjin.repackaged.guava.base.Predicate;
import org.renjin.repackaged.guava.base.Strings;
import org.renjin.repackaged.guava.collect.Iterators;
import org.renjin.repackaged.guava.collect.UnmodifiableIterator;
import org.renjin.sexp.AbstractSEXP;
import org.renjin.sexp.AtomicVector;
import org.renjin.sexp.AttributeMap;
import org.renjin.sexp.HasNamedValues;
import org.renjin.sexp.ListBuilder;
import org.renjin.sexp.ListVector;
import org.renjin.sexp.NamedValue;
import org.renjin.sexp.Null;
import org.renjin.sexp.Recursive;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.SEXPBuilder;
import org.renjin.sexp.SexpVisitor;
import org.renjin.sexp.StringVector;
import org.renjin.sexp.Symbol;
import org.renjin.sexp.Vector;

public interface PairList
extends SEXP {
    public static final String TYPE_NAME = "pairlist";

    @Override
    public <S extends SEXP> S getElementAsSEXP(int var1);

    public Iterable<Node> nodes();

    public Iterable<SEXP> values();

    public Vector toVector();

    public SEXP getRawTag();

    public Symbol getTag();

    public boolean hasTag();

    public void setTag(SEXP var1);

    public SEXP findByTag(Symbol var1);

    public PairList clone();

    public static abstract class Predicates {
        public static Predicate<Node> hasTag() {
            return new Predicate<Node>(){

                @Override
                public boolean apply(Node listExp) {
                    return listExp.hasTag();
                }
            };
        }

        public static Predicate<Node> matches(final String name) {
            return new Predicate<Node>(){

                @Override
                public boolean apply(Node input) {
                    if (input.getRawTag() instanceof Symbol) {
                        return ((Symbol)input.getRawTag()).getPrintName().equals(name);
                    }
                    return false;
                }
            };
        }

        public static Predicate<Node> matches(SEXP tag) {
            assert (tag instanceof Symbol);
            return Predicates.matches(((Symbol)tag).getPrintName());
        }

        public static Predicate<Node> startsWith(final Symbol name) {
            return new Predicate<Node>(){

                @Override
                public boolean apply(Node input) {
                    return input.hasTag() && input.getTag().getPrintName().startsWith(name.getPrintName());
                }
            };
        }
    }

    public static class Builder
    implements ListBuilder {
        protected Node head = null;
        protected Node tail;
        protected AttributeMap.Builder attributesBuilder = new AttributeMap.Builder();

        public Builder() {
        }

        public Builder(Node head) {
            this.head = head;
            this.tail = head;
        }

        public Builder withAttributes(AttributeMap attributes2) {
            this.attributesBuilder.addAllFrom(attributes2);
            return this;
        }

        @Override
        public Builder setAttribute(Symbol name, SEXP value) {
            this.attributesBuilder.set(name, value);
            return this;
        }

        @Override
        public SEXPBuilder removeAttribute(Symbol attributeName) {
            this.attributesBuilder.remove(attributeName);
            return this;
        }

        @Override
        public Builder setAttribute(String name, SEXP value) {
            this.attributesBuilder.set(name, value);
            return this;
        }

        @Override
        public int length() {
            if (this.head == null) {
                return 0;
            }
            return this.head.length();
        }

        @Override
        public int getIndexByName(String name) {
            if (this.head != null) {
                int i = 0;
                for (Node node : this.head.nodes()) {
                    if (node.hasTag() && node.getTag().getPrintName().equals(name)) {
                        return i;
                    }
                    ++i;
                }
            }
            return -1;
        }

        @Override
        public Builder remove(int index) {
            if (index == 0) {
                this.head = this.head.hasNextNode() ? this.head.getNextNode() : null;
            } else {
                Node precedingNode = this.head;
                for (int i = 0; i < index - 1; ++i) {
                    if (!precedingNode.hasNextNode()) {
                        throw new IndexOutOfBoundsException();
                    }
                    precedingNode = precedingNode.getNextNode();
                }
                Node removed = precedingNode.getNextNode();
                precedingNode.nextNode = removed.nextNode;
                if (removed == this.tail) {
                    this.tail = precedingNode;
                }
            }
            return this;
        }

        public Builder add(SEXP tag, SEXP s) {
            if (this.head == null) {
                this.tail = this.head = new Node(tag, s, this.attributesBuilder.build(), Null.INSTANCE);
            } else {
                Node next = new Node(tag, s, Null.INSTANCE);
                this.tail.nextNode = next;
                this.tail = next;
            }
            return this;
        }

        @Override
        public Builder add(Symbol name, SEXP value) {
            return this.add((SEXP)name, value);
        }

        public Builder addAll(PairList list2) {
            for (Node node : list2.nodes()) {
                this.add(node.getRawTag(), node.getValue());
            }
            return this;
        }

        public Builder addAll(ListVector list2) {
            for (NamedValue namedValue : list2.namedValues()) {
                this.add(namedValue.getName(), namedValue.getValue());
            }
            return this;
        }

        @Override
        public Builder add(SEXP s) {
            return this.add(Null.INSTANCE, s);
        }

        public Builder addCopy(Node node) {
            return this.add(node.getRawTag(), node.getValue());
        }

        @Override
        public Builder add(String name, SEXP value) {
            AbstractSEXP tag = Null.INSTANCE;
            if (!Strings.isNullOrEmpty(name)) {
                tag = Symbol.get(name);
            }
            return this.add(tag, value);
        }

        @Override
        public Builder set(int index, SEXP value) {
            if (index < 0) {
                throw new IndexOutOfBoundsException("index must be > 0");
            }
            if (this.head == null) {
                this.add(Null.INSTANCE);
            }
            Node node = this.head;
            for (int nodeIndex = 0; nodeIndex != index; ++nodeIndex) {
                if (node.nextNode == Null.INSTANCE) {
                    this.add(Null.INSTANCE);
                }
                node = node.getNextNode();
            }
            node.setValue(value);
            return this;
        }

        public Builder set(String name, SEXP value) {
            assert (name != null);
            if (this.head != null) {
                Node node = this.head;
                while (true) {
                    if (node.hasName() && node.getName().equals(name)) {
                        node.value = value;
                        return this;
                    }
                    if (!node.hasNextNode()) break;
                    node = node.getNextNode();
                }
            }
            return this.add(name, value);
        }

        @Override
        public PairList build() {
            if (this.head == null) {
                return Null.INSTANCE;
            }
            return this.buildNode();
        }

        Node buildNode() {
            if (this.head == null) {
                throw new IllegalStateException("no SEXPs have been added");
            }
            this.head.unsafeSetAttributes(this.attributesBuilder.build());
            return this.head;
        }
    }

    public static class Node
    extends AbstractSEXP
    implements Recursive,
    PairList,
    NamedValue,
    HasNamedValues {
        private SEXP tag = Null.INSTANCE;
        protected SEXP value = Null.INSTANCE;
        protected PairList nextNode = Null.INSTANCE;

        public Node(SEXP tag, SEXP value, AttributeMap attributes2, PairList nextNode) {
            super(attributes2);
            this.tag = tag;
            this.value = value;
            if (value == null) {
                throw new IllegalArgumentException("Node value can't be null");
            }
            if (nextNode instanceof Node) {
                this.nextNode = (Node)nextNode;
            }
        }

        public Node(SEXP tag, SEXP value, PairList nextNode) {
            super(AttributeMap.EMPTY);
            this.tag = tag;
            this.value = value;
            if (nextNode instanceof Node) {
                this.nextNode = nextNode;
            }
            if (value == null) {
                throw new IllegalArgumentException("Node value can't be null");
            }
        }

        public Node(SEXP value, PairList nextNode) {
            this(Null.INSTANCE, value, nextNode);
        }

        @Override
        public String getTypeName() {
            return PairList.TYPE_NAME;
        }

        public Node getNextNode() {
            if (!(this.nextNode instanceof Node)) {
                throw new IllegalStateException("no next node. call hasNextNode() first or use getSuccessor()");
            }
            return (Node)this.nextNode;
        }

        public PairList getNext() {
            return this.nextNode;
        }

        public boolean hasNextNode() {
            return this.nextNode != Null.INSTANCE;
        }

        public boolean tagEquals(String name) {
            return this.hasTag() && this.getTag().getPrintName().equals(name);
        }

        public static PairList fromIterable(Iterable<? extends SEXP> values) {
            Node head;
            Iterator<? extends SEXP> it = values.iterator();
            if (!it.hasNext()) {
                return Null.INSTANCE;
            }
            Node node = head = new Node(it.next(), Null.INSTANCE);
            while (it.hasNext()) {
                node.nextNode = new Node(it.next(), Null.INSTANCE);
                node = (Node)node.nextNode;
            }
            return head;
        }

        public static PairList fromArray(SEXP ... values) {
            return Node.fromIterable(Arrays.asList(values));
        }

        public static PairList fromVector(Vector vector2) {
            Builder builder = new Builder();
            for (int i = 0; i != vector2.length(); ++i) {
                String name = vector2.getName(i);
                if (Strings.isNullOrEmpty(name)) {
                    builder.add((SEXP)vector2.getElementAsSEXP(i));
                    continue;
                }
                builder.add(name, (SEXP)vector2.getElementAsSEXP(i));
            }
            return builder.build();
        }

        @Override
        public final SEXP getValue() {
            return this.value;
        }

        @Override
        public boolean hasName() {
            return this.hasTag();
        }

        @Override
        public String getName() {
            return this.hasTag() ? this.getTag().getPrintName() : "";
        }

        @Override
        public AtomicVector getNames() {
            StringVector.Builder names2 = new StringVector.Builder();
            boolean hasNames = false;
            for (Node node : this.nodes()) {
                if (node.hasTag()) {
                    names2.add(node.getTag().getPrintName());
                    hasNames = true;
                    continue;
                }
                names2.add("");
            }
            return (AtomicVector)((Object)(hasNames ? names2.build() : Null.INSTANCE));
        }

        public final void setValue(SEXP value) {
            this.value = value;
        }

        @Override
        public final SEXP getRawTag() {
            return this.tag;
        }

        @Override
        public final Symbol getTag() {
            return (Symbol)this.tag;
        }

        @Override
        public final boolean hasTag() {
            return this.tag != Null.INSTANCE;
        }

        @Override
        public void setTag(SEXP tag) {
            this.tag = tag;
        }

        public void setNextNode(Node nextNode) {
            this.nextNode = nextNode;
        }

        @Override
        protected SEXP cloneWithNewAttributes(AttributeMap newAttributes) {
            return new Node(this.tag, this.value, newAttributes, this.nextNode);
        }

        @Override
        public ListVector toVector() {
            ListVector.NamedBuilder builder = new ListVector.NamedBuilder();
            for (Node node : this.attributes.nodes()) {
                builder.setAttribute(node.getTag(), node.getValue());
            }
            for (Node node : this.nodes()) {
                if (node.hasTag()) {
                    builder.add(node.getTag().getPrintName(), node.getValue());
                    continue;
                }
                builder.add(node.getValue());
            }
            return builder.build();
        }

        public Iterator<SEXP> valueIterator() {
            return new ValueIterator(this);
        }

        @Override
        public Iterable<SEXP> values() {
            return new Iterable<SEXP>(){

                @Override
                public Iterator<SEXP> iterator() {
                    return new ValueIterator(Node.this);
                }
            };
        }

        @Override
        public final int length() {
            return Iterators.size(this.valueIterator());
        }

        public <X extends SEXP> X getElementAsSEXP(int i) {
            return (X)Iterators.get(this.valueIterator(), i);
        }

        public Node getNode(int i) {
            return Iterators.get(this.nodeIterator(), i);
        }

        @Override
        public String getName(int index) {
            Node node = this.getNode(index);
            if (node.hasTag()) {
                return node.getTag().getPrintName();
            }
            return StringVector.NA;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Node node = (Node)o;
            if (this.nextNode != null ? !this.nextNode.equals(node.nextNode) : node.nextNode != null) {
                return false;
            }
            if (this.tag != null ? !this.tag.equals(node.tag) : node.tag != null) {
                return false;
            }
            return !(this.value != null ? !this.value.equals(node.value) : node.value != null);
        }

        public int hashCode() {
            int result = 1;
            Node node = this;
            while (true) {
                result = 31 * result + (this.tag != null ? this.tag.hashCode() : 0);
                result = 31 * result + (node.value != null ? node.value.hashCode() : 0);
                if (node.nextNode == Null.INSTANCE) break;
                node = (Node)node.nextNode;
            }
            return result;
        }

        @Override
        public Node clone() {
            Builder builder = new Builder();
            for (Node node : this.nodes()) {
                builder.add(node.getRawTag(), node.getValue());
            }
            return builder.buildNode();
        }

        public String toString() {
            if (this.value == this) {
                return "[ CAR=this, CDR=" + this.nextNode + "]";
            }
            StringBuilder sb = new StringBuilder("pairlist(");
            this.appendValuesTo(sb);
            sb.append(")");
            return sb.toString();
        }

        public void appendValuesTo(StringBuilder sb) {
            for (Node node : this.nodes()) {
                if (node != this) {
                    sb.append(", ");
                }
                if (node.hasTag()) {
                    sb.append(node.getRawTag()).append("=");
                }
                sb.append(node.getValue());
            }
        }

        public Builder newCopyBuilder() {
            Builder builder = new Builder();
            for (Node node : this.nodes()) {
                builder.add(node.getRawTag(), node.getValue());
            }
            return builder;
        }

        public static Node singleton(Symbol tag, SEXP value) {
            return new Node(tag, value, Null.INSTANCE);
        }

        public static Node singleton(String tag, SEXP value) {
            return Node.singleton(Symbol.get(tag), value);
        }

        public static Node singleton(SEXP value) {
            return new Node(Null.INSTANCE, value, Null.INSTANCE);
        }

        @Override
        public Iterable<Node> nodes() {
            return new Iterable<Node>(){

                @Override
                public Iterator<Node> iterator() {
                    return Node.this.nodeIterator();
                }
            };
        }

        @Override
        public Iterable<NamedValue> namedValues() {
            return this.nodes();
        }

        public static Iterable<Node> listNodes(PairList exp2) {
            if (exp2 instanceof Node) {
                return exp2.nodes();
            }
            return Collections.emptySet();
        }

        private Iterator<Node> nodeIterator() {
            return new NodeIterator(this);
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        @Override
        public void accept(SexpVisitor visitor) {
            visitor.visit(this);
        }

        @Override
        public SEXP findByTag(Symbol symbol2) {
            for (Node node : this.nodes()) {
                if (!node.hasTag() || !node.getTag().equals(symbol2)) continue;
                return node.getValue();
            }
            return Null.INSTANCE;
        }

        private static class NodeIterator
        extends UnmodifiableIterator<Node> {
            private PairList next;

            private NodeIterator(Node next) {
                this.next = next;
            }

            @Override
            public boolean hasNext() {
                return this.next != Null.INSTANCE;
            }

            @Override
            public Node next() {
                Node value = (Node)this.next;
                this.next = value.getNext();
                return value;
            }
        }

        private static class ValueIterator
        extends UnmodifiableIterator<SEXP> {
            private PairList next = Null.INSTANCE;

            private ValueIterator(Node next) {
                this.next = next;
            }

            @Override
            public boolean hasNext() {
                return this.next != Null.INSTANCE;
            }

            @Override
            public SEXP next() {
                SEXP value = ((Node)this.next).value;
                this.next = ((Node)this.next).nextNode;
                return value;
            }
        }
    }
}

