/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.stats.dist;

import org.renjin.primitives.vector.DeferredComputation;
import org.renjin.sexp.AttributeMap;
import org.renjin.sexp.DoubleVector;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.Vector;

public class Euclidean1dDistanceTriangle
extends DoubleVector
implements DeferredComputation {
    private Vector vector;
    private int length;
    private int size;

    public Euclidean1dDistanceTriangle(Vector vector2, AttributeMap attributes2) {
        super(attributes2);
        this.vector = vector2;
        this.size = vector2.length();
        this.length = this.size * (this.size - 1) / 2;
    }

    public Vector getVector() {
        return this.vector;
    }

    @Override
    public Vector[] getOperands() {
        return new Vector[0];
    }

    @Override
    public String getComputationName() {
        return "dist";
    }

    @Override
    protected SEXP cloneWithNewAttributes(AttributeMap attributes2) {
        return new Euclidean1dDistanceTriangle(this.vector, attributes2);
    }

    @Override
    public double getElementAsDouble(int index) {
        int colStart = 0;
        int col2 = 0;
        while (true) {
            int colLength;
            if (index < colStart + (colLength = this.size - col2 - 1)) {
                int row2 = col2 + 1 + (index - colStart);
                return Math.abs(this.vector.getElementAsDouble(row2) - this.vector.getElementAsDouble(col2));
            }
            colStart += colLength;
            ++col2;
        }
    }

    @Override
    public boolean isConstantAccessTime() {
        return this.vector.isConstantAccessTime();
    }

    @Override
    public boolean isDeferred() {
        return true;
    }

    @Override
    public int length() {
        return this.length;
    }
}

