/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.stats.internals.distributions;

import org.renjin.eval.EvalException;
import org.renjin.eval.Session;
import org.renjin.invoke.annotations.Current;
import org.renjin.invoke.annotations.Internal;
import org.renjin.sexp.AtomicVector;
import org.renjin.sexp.IntArrayVector;
import org.renjin.sexp.IntVector;
import org.renjin.sexp.Null;
import org.renjin.util.HeapsortTandem;

public class Sampling {
    public static int RouletteWheel(double[] cumulativeDist, double rand) {
        int result = 0;
        for (int i = 0; i < cumulativeDist.length - 1; ++i) {
            if (!(rand > cumulativeDist[i]) || !(rand < cumulativeDist[i + 1])) continue;
            return i + 1;
        }
        return result;
    }

    public static IntVector sampleWithReplacement(Session context, int size, double[] prob) {
        int i;
        double[] cumProbs = new double[prob.length];
        IntArrayVector.Builder resultb = IntArrayVector.Builder.withInitialCapacity(size);
        cumProbs[0] = prob[0];
        for (i = 1; i < cumProbs.length; ++i) {
            cumProbs[i] = prob[i] + cumProbs[i - 1];
        }
        for (i = 0; i < size; ++i) {
            double arand = context.rng.unif_rand();
            int index = Sampling.RouletteWheel(cumProbs, arand);
            resultb.add(index + 1);
        }
        return resultb.build();
    }

    public static IntVector uniformSampleWithoutReplacement(Session context, int sampleSpaceSize, int sampleSize) {
        int i;
        int[] x = new int[sampleSpaceSize];
        IntArrayVector.Builder y = new IntArrayVector.Builder();
        for (i = 0; i < sampleSpaceSize; ++i) {
            x[i] = i;
        }
        for (i = 0; i < sampleSize; ++i) {
            int j = (int)Math.floor((double)sampleSpaceSize * context.rng.unif_rand());
            y.add(x[j] + 1);
            x[j] = x[--sampleSpaceSize];
        }
        return y.build();
    }

    public static IntVector probSampleWithoutReplacement(Session context, int n, int sampleSize, double[] probs) {
        int i;
        int[] x = new int[n];
        IntArrayVector.Builder y = new IntArrayVector.Builder();
        for (i = 0; i < n; ++i) {
            x[i] = i + 1;
        }
        HeapsortTandem.heapsortDescending(probs, x, n);
        double totalmass = 1.0;
        i = 0;
        int n1 = n - 1;
        while (i < sampleSize) {
            int j;
            double rT = totalmass * context.rng.unif_rand();
            double mass = 0.0;
            for (j = 0; j < n1 && !(rT <= (mass += probs[j])); ++j) {
            }
            y.add(x[j]);
            totalmass -= probs[j];
            for (int k = j; k < n1; ++k) {
                probs[k] = probs[k + 1];
                x[k] = x[k + 1];
            }
            ++i;
            --n1;
        }
        return y.build();
    }

    @Internal
    public static IntVector sample(@Current Session context, int populationSize, int sampleSize, boolean withReplacement, AtomicVector probabilityWeights) {
        boolean probabilitiesGiven;
        boolean bl = probabilitiesGiven = probabilityWeights != Null.INSTANCE;
        if (!probabilitiesGiven) {
            if (withReplacement) {
                return Sampling.uniformSampleWithReplacement(context, populationSize, sampleSize);
            }
            return Sampling.uniformSampleWithoutReplacement(context, populationSize, sampleSize);
        }
        double[] probs = Sampling.weightsToProbabilities(probabilityWeights, populationSize, sampleSize, withReplacement);
        if (withReplacement) {
            return Sampling.sampleWithReplacement(context, sampleSize, probs);
        }
        return Sampling.probSampleWithoutReplacement(context, populationSize, sampleSize, probs);
    }

    private static IntVector uniformSampleWithReplacement(Session context, int populationSize, int sampleSize) {
        double dn = populationSize;
        int[] sample2 = new int[sampleSize];
        for (int i = 0; i < sample2.length; ++i) {
            sample2[i] = (int)Math.floor(dn * context.rng.unif_rand() + 1.0);
        }
        return new IntArrayVector(sample2);
    }

    private static double[] weightsToProbabilities(AtomicVector weightVector, int populationSize, int sampleSize, boolean replace) {
        int i;
        if (weightVector.length() != populationSize) {
            throw new EvalException("incorrect number of probabilities", new Object[0]);
        }
        double[] weights = weightVector.toDoubleArray();
        int npos = 0;
        double sum2 = 0.0;
        for (i = 0; i < populationSize; ++i) {
            if (weights[i] < 0.0) {
                throw new EvalException("non-positive probability", new Object[0]);
            }
            if (!(weights[i] > 0.0)) continue;
            ++npos;
            sum2 += weights[i];
        }
        if (npos == 0 || !replace && sampleSize > npos) {
            throw new EvalException("too few positive probabilities", new Object[0]);
        }
        i = 0;
        while (i < populationSize) {
            int n = i++;
            weights[n] = weights[n] / sum2;
        }
        return weights;
    }
}

