/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.util;

import java.io.File;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.impl.DefaultFileSystemManager;
import org.apache.commons.vfs2.provider.FileProvider;
import org.apache.commons.vfs2.provider.local.DefaultLocalFileProvider;
import org.apache.commons.vfs2.provider.res.ResourceFileProvider;
import org.apache.commons.vfs2.provider.url.UrlFileProvider;
import org.renjin.eval.vfs.FastJarFileProvider;
import org.renjin.repackaged.guava.annotations.VisibleForTesting;

public class FileSystemUtils {
    public static String homeDirectoryInCoreJar() {
        return FileSystemUtils.embeddedRHomeFromSEXPClassURL(org.renjin.primitives.System.class.getResource("/org/renjin/sexp/SEXP.class").toString());
    }

    public static String homeDirectoryInLocalFs() {
        return FileSystemUtils.localRHomeFromSEXPClassURL(org.renjin.primitives.System.class.getResource("/org/renjin/sexp/SEXP.class").toString());
    }

    @VisibleForTesting
    public static String embeddedRHomeFromSEXPClassURL(String url2) {
        String homeUrl = url2.substring(0, url2.length() - "/org/renjin/sexp/SEXP.class".length()) + "/org/renjin";
        if (homeUrl.startsWith("file:/")) {
            homeUrl = homeUrl.substring("file:".length());
        }
        return homeUrl;
    }

    @VisibleForTesting
    public static String localRHomeFromSEXPClassURL(String url2) {
        String homeUrl = url2.substring(0, url2.length() - "/org/renjin/sexp/SEXP.class".length());
        if (homeUrl.endsWith(".jar!") && homeUrl.startsWith("jar:file:")) {
            int depDir = homeUrl.lastIndexOf(47);
            int homeDir = homeUrl.lastIndexOf(47, depDir - 1);
            if (depDir == -1 || homeDir == -1) {
                throw new IllegalStateException("Can't figure out the R_HOME from the jar location '" + homeUrl + "'");
            }
            return homeUrl.substring("jar:".length(), homeDir);
        }
        return url2.substring(0, url2.length() - "/sexp/SEXP.class".length());
    }

    public static String libraryPathsFromClassPath() {
        return FileSystemUtils.libraryPathsFromClassPath(System.getProperty("java.class.path"));
    }

    @VisibleForTesting
    public static String libraryPathsFromClassPath(String classPathString) {
        StringBuilder path2 = new StringBuilder();
        if (classPathString != null) {
            String[] classPaths;
            for (String classPath : classPaths = classPathString.split(File.pathSeparator)) {
                String libraryPath = FileSystemUtils.libraryPathFromClassPathEntry(classPath);
                if (libraryPath == null) continue;
                if (path2.length() != 0) {
                    path2.append(";");
                }
                path2.append(libraryPath);
            }
        }
        return path2.toString();
    }

    public static String libraryPathFromClassPathEntry(String classPath) {
        if (classPath.endsWith(".jar")) {
            return FileSystemUtils.libraryPathFromJarFile(classPath);
        }
        return FileSystemUtils.libraryPathFromFolder(classPath);
    }

    public static String libraryPathFromFolder(String classPath) {
        try {
            return new File(classPath).getAbsolutePath();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String libraryPathFromJarFile(String classPath) {
        return "jar:file://" + FileSystemUtils.absolutePath(classPath);
    }

    private static String absolutePath(String path2) {
        return new File(path2).getAbsolutePath();
    }

    public static FileObject workingDirectory(FileSystemManager fileSystemManager) {
        try {
            return fileSystemManager.resolveFile(new File("").getAbsolutePath());
        }
        catch (FileSystemException e) {
            throw new RuntimeException("Could not resolve current working directory", e);
        }
    }

    public static FileSystemManager getMinimalFileSystemManager() throws FileSystemException {
        DefaultFileSystemManager fsm = new DefaultFileSystemManager();
        fsm.setDefaultProvider(new UrlFileProvider());
        fsm.addProvider("file", (FileProvider)new DefaultLocalFileProvider());
        fsm.addProvider("jar", (FileProvider)new FastJarFileProvider());
        fsm.addProvider("res", (FileProvider)new ResourceFileProvider());
        fsm.init();
        return fsm;
    }
}

