/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.utils;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.renjin.eval.Context;
import org.renjin.invoke.annotations.Current;
import org.renjin.parser.NumericLiterals;
import org.renjin.primitives.io.connections.Connections;
import org.renjin.primitives.io.connections.PushbackBufferedReader;
import org.renjin.repackaged.guava.base.Strings;
import org.renjin.repackaged.guava.collect.Maps;
import org.renjin.repackaged.guava.collect.Sets;
import org.renjin.sexp.DoubleArrayVector;
import org.renjin.sexp.DoubleVector;
import org.renjin.sexp.IntArrayVector;
import org.renjin.sexp.LogicalArrayVector;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.StringVector;
import org.renjin.sexp.Symbols;
import org.renjin.sexp.Vector;

public class Tables {
    public static StringVector readtablehead(@Current Context context, SEXP conn, double nLines, String commentChar, boolean blankLinesSkip, String quote, String sep, boolean skipNul) throws IOException {
        String line;
        PushbackBufferedReader reader = Connections.getConnection(context, conn).getReader();
        StringVector.Builder head = new StringVector.Builder();
        while (nLines > 0.0 && (line = reader.readLine()) != null) {
            if (!commentChar.isEmpty() && line.startsWith(commentChar)) continue;
            head.add(line);
            nLines -= 1.0;
        }
        return head.build();
    }

    public static Vector typeconvert(StringVector vector2, StringVector naStrings, boolean asIs, String dec, String numerals) {
        Set<String> naSet = Tables.createHashSet(naStrings);
        Converter<?> converter = Tables.getConverter(vector2, naSet, dec.charAt(0));
        if (converter != null) {
            return converter.build(vector2, naSet);
        }
        if (asIs) {
            return vector2;
        }
        return Tables.buildFactor(vector2, naSet);
    }

    private static Set<String> createHashSet(StringVector strings) {
        HashSet<String> set2 = Sets.newHashSet();
        for (int i = 0; i < strings.length(); ++i) {
            String element = strings.getElementAsString(i);
            if (Strings.isNullOrEmpty(element)) continue;
            set2.add(element);
        }
        return set2;
    }

    private static Vector buildFactor(StringVector vector2, Set<String> naStrings) {
        HashMap<String, Integer> codes = Maps.newHashMap();
        IntArrayVector.Builder factor = new IntArrayVector.Builder(vector2.length());
        for (int i = 0; i != vector2.length(); ++i) {
            String element = vector2.getElementAsString(i);
            if (Tables.isNa(element, naStrings)) continue;
            Integer code = (Integer)codes.get(element);
            if (code == null) {
                code = codes.size() + 1;
                codes.put(element, code);
            }
            factor.set(i, code);
        }
        StringVector.Builder levels2 = StringVector.newBuilder();
        for (Map.Entry level : codes.entrySet()) {
            levels2.set((Integer)level.getValue() - 1, (String)level.getKey());
        }
        factor.setAttribute(Symbols.CLASS, (SEXP)StringVector.valueOf("factor"));
        factor.setAttribute(Symbols.LEVELS, (SEXP)levels2.build());
        return factor.build();
    }

    private static boolean isNa(String string, Set<String> naStrings) {
        return Strings.isNullOrEmpty(string) || naStrings.contains(string);
    }

    private static Converter<?> getConverter(StringVector vector2, Set<String> naStrings, char decimal) {
        Converter[] converters;
        for (Converter converter : converters = new Converter[]{new LogicalConverter(), new IntConverter(), new DoubleConverter(decimal)}) {
            if (!converter.accept(vector2, naStrings)) continue;
            return converter;
        }
        return null;
    }

    private static class DoubleConverter
    extends Converter<DoubleArrayVector.Builder> {
        private final char decimal;

        public DoubleConverter(char decimal) {
            this.decimal = decimal;
        }

        @Override
        public boolean accept(String string) {
            try {
                return !DoubleVector.isNA(NumericLiterals.parseDouble(string, 0, string.length(), this.decimal, false));
            }
            catch (Exception e) {
                return false;
            }
        }

        @Override
        public void set(DoubleArrayVector.Builder builder, int index, String string) {
            builder.set(index, NumericLiterals.parseDouble(string, 0, string.length(), this.decimal, false));
        }

        @Override
        DoubleArrayVector.Builder newBuilder(int length2) {
            return new DoubleArrayVector.Builder(length2);
        }
    }

    private static class IntConverter
    extends Converter<IntArrayVector.Builder> {
        private IntConverter() {
        }

        @Override
        public boolean accept(String string) {
            try {
                double doubleValue = NumericLiterals.parseDouble(string);
                int intValue = (int)doubleValue;
                return (double)intValue == doubleValue;
            }
            catch (Exception e) {
                return false;
            }
        }

        @Override
        public void set(IntArrayVector.Builder builder, int index, String string) {
            builder.set(index, NumericLiterals.parseInt(string));
        }

        @Override
        public IntArrayVector.Builder newBuilder(int length2) {
            return new IntArrayVector.Builder(length2);
        }
    }

    private static class LogicalConverter
    extends Converter<LogicalArrayVector.Builder> {
        private LogicalConverter() {
        }

        @Override
        public boolean accept(String string) {
            return string.equals("T") || string.equals("F") || string.equals("TRUE") || string.equals("FALSE");
        }

        @Override
        public void set(LogicalArrayVector.Builder builder, int index, String string) {
            if (string.equals("T") || string.equals("TRUE")) {
                builder.set(index, true);
            } else {
                builder.set(index, false);
            }
        }

        @Override
        LogicalArrayVector.Builder newBuilder(int length2) {
            return new LogicalArrayVector.Builder(length2);
        }
    }

    private static abstract class Converter<BuilderT extends Vector.Builder> {
        private Converter() {
        }

        abstract boolean accept(String var1);

        abstract BuilderT newBuilder(int var1);

        abstract void set(BuilderT var1, int var2, String var3);

        public boolean accept(StringVector vector2, Set<String> naStrings) {
            for (int i = 0; i != vector2.length(); ++i) {
                String element = vector2.getElementAsString(i);
                if (Tables.isNa(element, naStrings) || this.accept(element)) continue;
                return false;
            }
            return true;
        }

        public Vector build(StringVector vector2, Set<String> naStrings) {
            BuilderT builder = this.newBuilder(vector2.length());
            for (int i = 0; i != vector2.length(); ++i) {
                String element = vector2.getElementAsString(i);
                if (Tables.isNa(element, naStrings)) continue;
                this.set(builder, i, element);
            }
            return builder.build();
        }
    }
}

