/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.genetics;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.math.genetics.AbstractListChromosome;
import org.apache.commons.math.genetics.Chromosome;
import org.apache.commons.math.genetics.GeneticAlgorithm;
import org.apache.commons.math.genetics.InvalidRepresentationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BinaryChromosome
extends AbstractListChromosome<Integer> {
    public BinaryChromosome(List<Integer> representation) {
        super(representation);
    }

    public BinaryChromosome(Integer[] representation) {
        super(representation);
    }

    @Override
    protected void checkValidity(List<Integer> chromosomeRepresentation) throws InvalidRepresentationException {
        for (int i : chromosomeRepresentation) {
            if (i >= 0 && i <= 1) continue;
            throw new InvalidRepresentationException("Elements can be only 0 or 1.");
        }
    }

    public static List<Integer> randomBinaryRepresentation(int length2) {
        ArrayList<Integer> rList = new ArrayList<Integer>(length2);
        for (int j = 0; j < length2; ++j) {
            rList.add(GeneticAlgorithm.getRandomGenerator().nextInt(2));
        }
        return rList;
    }

    @Override
    protected boolean isSame(Chromosome another) {
        if (!(another instanceof BinaryChromosome)) {
            return false;
        }
        BinaryChromosome anotherBc = (BinaryChromosome)another;
        if (this.getLength() != anotherBc.getLength()) {
            return false;
        }
        for (int i = 0; i < this.getRepresentation().size(); ++i) {
            if (((Integer)this.getRepresentation().get(i)).equals(anotherBc.getRepresentation().get(i))) continue;
            return false;
        }
        return true;
    }
}

