/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.optimization.direct;

import java.util.Comparator;
import org.apache.commons.math.FunctionEvaluationException;
import org.apache.commons.math.optimization.OptimizationException;
import org.apache.commons.math.optimization.RealPointValuePair;
import org.apache.commons.math.optimization.direct.DirectSearchOptimizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NelderMead
extends DirectSearchOptimizer {
    private final double rho;
    private final double khi;
    private final double gamma;
    private final double sigma;

    public NelderMead() {
        this.rho = 1.0;
        this.khi = 2.0;
        this.gamma = 0.5;
        this.sigma = 0.5;
    }

    public NelderMead(double rho, double khi, double gamma2, double sigma) {
        this.rho = rho;
        this.khi = khi;
        this.gamma = gamma2;
        this.sigma = sigma;
    }

    @Override
    protected void iterateSimplex(Comparator<RealPointValuePair> comparator) throws FunctionEvaluationException, OptimizationException {
        int j;
        this.incrementIterationsCounter();
        int n = this.simplex.length - 1;
        RealPointValuePair best = this.simplex[0];
        RealPointValuePair secondBest = this.simplex[n - 1];
        RealPointValuePair worst = this.simplex[n];
        double[] xWorst = worst.getPointRef();
        double[] centroid = new double[n];
        for (int i = 0; i < n; ++i) {
            double[] x = this.simplex[i].getPointRef();
            for (j = 0; j < n; ++j) {
                int n2 = j;
                centroid[n2] = centroid[n2] + x[j];
            }
        }
        double scaling = 1.0 / (double)n;
        j = 0;
        while (j < n) {
            int n3 = j++;
            centroid[n3] = centroid[n3] * scaling;
        }
        double[] xR = new double[n];
        for (int j2 = 0; j2 < n; ++j2) {
            xR[j2] = centroid[j2] + this.rho * (centroid[j2] - xWorst[j2]);
        }
        RealPointValuePair reflected = new RealPointValuePair(xR, this.evaluate(xR), false);
        if (comparator.compare(best, reflected) <= 0 && comparator.compare(reflected, secondBest) < 0) {
            this.replaceWorstPoint(reflected, comparator);
        } else if (comparator.compare(reflected, best) < 0) {
            double[] xE = new double[n];
            for (int j3 = 0; j3 < n; ++j3) {
                xE[j3] = centroid[j3] + this.khi * (xR[j3] - centroid[j3]);
            }
            RealPointValuePair expanded = new RealPointValuePair(xE, this.evaluate(xE), false);
            if (comparator.compare(expanded, reflected) < 0) {
                this.replaceWorstPoint(expanded, comparator);
            } else {
                this.replaceWorstPoint(reflected, comparator);
            }
        } else {
            double[] xC;
            if (comparator.compare(reflected, worst) < 0) {
                xC = new double[n];
                for (int j4 = 0; j4 < n; ++j4) {
                    xC[j4] = centroid[j4] + this.gamma * (xR[j4] - centroid[j4]);
                }
                RealPointValuePair outContracted = new RealPointValuePair(xC, this.evaluate(xC), false);
                if (comparator.compare(outContracted, reflected) <= 0) {
                    this.replaceWorstPoint(outContracted, comparator);
                    return;
                }
            } else {
                xC = new double[n];
                for (int j5 = 0; j5 < n; ++j5) {
                    xC[j5] = centroid[j5] - this.gamma * (centroid[j5] - xWorst[j5]);
                }
                RealPointValuePair inContracted = new RealPointValuePair(xC, this.evaluate(xC), false);
                if (comparator.compare(inContracted, worst) < 0) {
                    this.replaceWorstPoint(inContracted, comparator);
                    return;
                }
            }
            double[] xSmallest = this.simplex[0].getPointRef();
            for (int i = 1; i < this.simplex.length; ++i) {
                double[] x = this.simplex[i].getPoint();
                for (int j6 = 0; j6 < n; ++j6) {
                    x[j6] = xSmallest[j6] + this.sigma * (x[j6] - xSmallest[j6]);
                }
                this.simplex[i] = new RealPointValuePair(x, Double.NaN, false);
            }
            this.evaluateSimplex(comparator);
        }
    }
}

