/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.stat.descriptive.moment;

import java.io.Serializable;
import org.apache.commons.math.stat.descriptive.AbstractStorelessUnivariateStatistic;
import org.apache.commons.math.stat.descriptive.WeightedEvaluation;
import org.apache.commons.math.stat.descriptive.moment.FirstMoment;
import org.apache.commons.math.stat.descriptive.summary.Sum;

public class Mean
extends AbstractStorelessUnivariateStatistic
implements Serializable,
WeightedEvaluation {
    private static final long serialVersionUID = -1296043746617791564L;
    protected FirstMoment moment;
    protected boolean incMoment;

    public Mean() {
        this.incMoment = true;
        this.moment = new FirstMoment();
    }

    public Mean(FirstMoment m1) {
        this.moment = m1;
        this.incMoment = false;
    }

    public Mean(Mean original) {
        Mean.copy(original, this);
    }

    public void increment(double d) {
        if (this.incMoment) {
            this.moment.increment(d);
        }
    }

    public void clear() {
        if (this.incMoment) {
            this.moment.clear();
        }
    }

    public double getResult() {
        return this.moment.m1;
    }

    public long getN() {
        return this.moment.getN();
    }

    public double evaluate(double[] values, int begin, int length2) {
        if (this.test(values, begin, length2)) {
            Sum sum2 = new Sum();
            double sampleSize = length2;
            double xbar = sum2.evaluate(values, begin, length2) / sampleSize;
            double correction = 0.0;
            for (int i = begin; i < begin + length2; ++i) {
                correction += values[i] - xbar;
            }
            return xbar + correction / sampleSize;
        }
        return Double.NaN;
    }

    public double evaluate(double[] values, double[] weights, int begin, int length2) {
        if (this.test(values, weights, begin, length2)) {
            Sum sum2 = new Sum();
            double sumw = sum2.evaluate(weights, begin, length2);
            double xbarw = sum2.evaluate(values, weights, begin, length2) / sumw;
            double correction = 0.0;
            for (int i = begin; i < begin + length2; ++i) {
                correction += weights[i] * (values[i] - xbarw);
            }
            return xbarw + correction / sumw;
        }
        return Double.NaN;
    }

    public double evaluate(double[] values, double[] weights) {
        return this.evaluate(values, weights, 0, values.length);
    }

    public Mean copy() {
        Mean result = new Mean();
        Mean.copy(this, result);
        return result;
    }

    public static void copy(Mean source, Mean dest) {
        dest.setData(source.getDataRef());
        dest.incMoment = source.incMoment;
        dest.moment = source.moment.copy();
    }
}

