/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.vfs2.CacheStrategy;
import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileListener;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSelector;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.FilesCache;
import org.apache.commons.vfs2.VfsLog;
import org.apache.commons.vfs2.cache.OnCallRefreshFileObject;
import org.apache.commons.vfs2.events.AbstractFileChangeEvent;
import org.apache.commons.vfs2.events.ChangedEvent;
import org.apache.commons.vfs2.events.CreateEvent;
import org.apache.commons.vfs2.events.DeleteEvent;
import org.apache.commons.vfs2.impl.DefaultFileSystemConfigBuilder;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.apache.commons.vfs2.provider.AbstractVfsComponent;
import org.apache.commons.vfs2.provider.FileSystemKey;
import org.apache.commons.vfs2.util.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFileSystem
extends AbstractVfsComponent
implements FileSystem {
    private static final Log LOG = LogFactory.getLog(AbstractFileSystem.class);
    private final FileName rootName;
    private final String rootURI;
    private FileObject parentLayer;
    private final Collection<Capability> caps = new HashSet<Capability>();
    private final Map<FileName, ArrayList<FileListener>> listenerMap = new HashMap<FileName, ArrayList<FileListener>>();
    private final FileSystemOptions fileSystemOptions;
    private final AtomicLong useCount = new AtomicLong(0L);
    private FileSystemKey cacheKey;
    private final AtomicInteger openStreams = new AtomicInteger(0);

    protected AbstractFileSystem(FileName rootName, FileObject parentLayer, FileSystemOptions fileSystemOptions) {
        this.parentLayer = parentLayer;
        this.rootName = rootName;
        this.fileSystemOptions = fileSystemOptions;
        DefaultFileSystemConfigBuilder builder = DefaultFileSystemConfigBuilder.getInstance();
        String uri = builder.getRootURI(fileSystemOptions);
        if (uri == null) {
            uri = rootName.getURI();
        }
        this.rootURI = uri;
    }

    @Override
    public void init() throws FileSystemException {
        this.addCapabilities(this.caps);
    }

    @Override
    public void close() {
        this.closeCommunicationLink();
        this.parentLayer = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeCommunicationLink() {
        AbstractFileSystem abstractFileSystem = this;
        synchronized (abstractFileSystem) {
            this.doCloseCommunicationLink();
        }
    }

    protected void doCloseCommunicationLink() {
    }

    protected abstract FileObject createFile(AbstractFileName var1) throws Exception;

    protected abstract void addCapabilities(Collection<Capability> var1);

    @Override
    public FileName getRootName() {
        return this.rootName;
    }

    @Override
    public String getRootURI() {
        return this.rootURI;
    }

    protected void putFileToCache(FileObject file2) {
        this.getCache().putFile(file2);
    }

    private FilesCache getCache() {
        FilesCache files2 = this.getContext().getFileSystemManager().getFilesCache();
        if (files2 == null) {
            throw new RuntimeException(Messages.getString("vfs.provider/files-cache-missing.error"));
        }
        return files2;
    }

    protected FileObject getFileFromCache(FileName name) {
        return this.getCache().getFile(this, name);
    }

    protected void removeFileFromCache(FileName name) {
        this.getCache().removeFile(this, name);
    }

    @Override
    public boolean hasCapability(Capability capability) {
        return this.caps.contains((Object)capability);
    }

    @Override
    public Object getAttribute(String attrName) throws FileSystemException {
        throw new FileSystemException("vfs.provider/get-attribute-not-supported.error");
    }

    @Override
    public void setAttribute(String attrName, Object value) throws FileSystemException {
        throw new FileSystemException("vfs.provider/set-attribute-not-supported.error");
    }

    @Override
    public FileObject getParentLayer() throws FileSystemException {
        return this.parentLayer;
    }

    @Override
    public FileObject getRoot() throws FileSystemException {
        return this.resolveFile(this.rootName);
    }

    @Override
    public FileObject resolveFile(String nameStr) throws FileSystemException {
        FileName name = this.getFileSystemManager().resolveName(this.rootName, nameStr);
        return this.resolveFile(name);
    }

    @Override
    public FileObject resolveFile(FileName name) throws FileSystemException {
        return this.resolveFile(name, true);
    }

    private synchronized FileObject resolveFile(FileName name, boolean useCache) throws FileSystemException {
        if (!this.rootName.getRootURI().equals(name.getRootURI())) {
            throw new FileSystemException("vfs.provider/mismatched-fs-for-name.error", new Object[]{name, this.rootName, name.getRootURI()});
        }
        FileObject file2 = useCache ? this.getFileFromCache(name) : null;
        if (file2 == null) {
            try {
                file2 = this.createFile((AbstractFileName)name);
            }
            catch (Exception e) {
                throw new FileSystemException("vfs.provider/resolve-file.error", name, (Throwable)e);
            }
            file2 = this.decorateFileObject(file2);
            if (useCache) {
                this.putFileToCache(file2);
            }
        }
        if (this.getFileSystemManager().getCacheStrategy().equals((Object)CacheStrategy.ON_RESOLVE)) {
            file2.refresh();
        }
        return file2;
    }

    protected FileObject decorateFileObject(FileObject file2) throws FileSystemException {
        if (this.getFileSystemManager().getCacheStrategy().equals((Object)CacheStrategy.ON_CALL)) {
            file2 = new OnCallRefreshFileObject(file2);
        }
        if (this.getFileSystemManager().getFileObjectDecoratorConst() != null) {
            try {
                file2 = (FileObject)this.getFileSystemManager().getFileObjectDecoratorConst().newInstance(file2);
            }
            catch (InstantiationException e) {
                throw new FileSystemException("vfs.impl/invalid-decorator.error", this.getFileSystemManager().getFileObjectDecorator().getName(), (Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new FileSystemException("vfs.impl/invalid-decorator.error", this.getFileSystemManager().getFileObjectDecorator().getName(), (Throwable)e);
            }
            catch (InvocationTargetException e) {
                throw new FileSystemException("vfs.impl/invalid-decorator.error", this.getFileSystemManager().getFileObjectDecorator().getName(), (Throwable)e);
            }
        }
        return file2;
    }

    @Override
    public File replicateFile(FileObject file2, FileSelector selector) throws FileSystemException {
        if (!file2.exists()) {
            throw new FileSystemException("vfs.provider/replicate-missing-file.error", file2.getName());
        }
        try {
            return this.doReplicateFile(file2, selector);
        }
        catch (Exception e) {
            throw new FileSystemException("vfs.provider/replicate-file.error", file2.getName(), (Throwable)e);
        }
    }

    @Override
    public FileSystemOptions getFileSystemOptions() {
        return this.fileSystemOptions;
    }

    @Override
    public FileSystemManager getFileSystemManager() {
        return this.getContext().getFileSystemManager();
    }

    @Override
    public double getLastModTimeAccuracy() {
        return 0.0;
    }

    protected File doReplicateFile(FileObject file2, FileSelector selector) throws Exception {
        return this.getContext().getReplicator().replicateFile(file2, selector);
    }

    @Override
    public void addJunction(String junctionPoint, FileObject targetFile) throws FileSystemException {
        throw new FileSystemException("vfs.provider/junctions-not-supported.error", this.rootName);
    }

    @Override
    public void removeJunction(String junctionPoint) throws FileSystemException {
        throw new FileSystemException("vfs.provider/junctions-not-supported.error", this.rootName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(FileObject file2, FileListener listener) {
        Map<FileName, ArrayList<FileListener>> map = this.listenerMap;
        synchronized (map) {
            ArrayList<FileListener> listeners = this.listenerMap.get(file2.getName());
            if (listeners == null) {
                listeners = new ArrayList();
                this.listenerMap.put(file2.getName(), listeners);
            }
            listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(FileObject file2, FileListener listener) {
        Map<FileName, ArrayList<FileListener>> map = this.listenerMap;
        synchronized (map) {
            ArrayList<FileListener> listeners = this.listenerMap.get(file2.getName());
            if (listeners != null) {
                listeners.remove(listener);
                if (listeners.isEmpty()) {
                    this.listenerMap.remove(file2.getName());
                }
            }
        }
    }

    public void fireFileCreated(FileObject file2) {
        this.fireEvent(new CreateEvent(file2));
    }

    public void fireFileDeleted(FileObject file2) {
        this.fireEvent(new DeleteEvent(file2));
    }

    public void fireFileChanged(FileObject file2) {
        this.fireEvent(new ChangedEvent(file2));
    }

    public boolean isReleaseable() {
        return this.useCount.get() < 1L;
    }

    void freeResources() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireEvent(AbstractFileChangeEvent event) {
        FileListener[] fileListeners = null;
        FileObject file2 = event.getFile();
        Map<FileName, ArrayList<FileListener>> map = this.listenerMap;
        synchronized (map) {
            ArrayList<FileListener> listeners = this.listenerMap.get(file2.getName());
            if (listeners != null) {
                fileListeners = listeners.toArray(new FileListener[listeners.size()]);
            }
        }
        if (fileListeners != null) {
            for (int i = 0; i < fileListeners.length; ++i) {
                FileListener fileListener = fileListeners[i];
                try {
                    event.notify(fileListener);
                    continue;
                }
                catch (Exception e) {
                    String message = Messages.getString("vfs.provider/notify-listener.warn", file2);
                    VfsLog.warn(this.getLogger(), LOG, message, e);
                }
            }
        }
    }

    void fileObjectHanded(FileObject fileObject) {
        this.useCount.incrementAndGet();
    }

    void fileObjectDestroyed(FileObject fileObject) {
        this.useCount.decrementAndGet();
    }

    void setCacheKey(FileSystemKey cacheKey) {
        this.cacheKey = cacheKey;
    }

    FileSystemKey getCacheKey() {
        return this.cacheKey;
    }

    void streamOpened() {
        this.openStreams.incrementAndGet();
    }

    void streamClosed() {
        int count;
        do {
            if ((count = this.openStreams.get()) >= 1) continue;
            return;
        } while (this.openStreams.compareAndSet(count, count - 1));
        if (count == 1) {
            this.notifyAllStreamsClosed();
        }
    }

    protected void notifyAllStreamsClosed() {
    }

    public boolean isOpen() {
        return this.openStreams.get() > 0;
    }
}

