/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.util;

import java.lang.ref.WeakReference;
import org.apache.commons.vfs2.FileChangeEvent;
import org.apache.commons.vfs2.FileListener;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystem;

public class WeakRefFileListener
implements FileListener {
    private final FileSystem fs;
    private final FileName name;
    private final WeakReference<FileListener> listener;

    protected WeakRefFileListener(FileObject file2, FileListener listener) {
        this.fs = file2.getFileSystem();
        this.name = file2.getName();
        this.listener = new WeakReference<FileListener>(listener);
    }

    public static void installListener(FileObject file2, FileListener listener) {
        WeakRefFileListener weakListener = new WeakRefFileListener(file2, listener);
        file2.getFileSystem().addListener(file2, new WeakRefFileListener(file2, weakListener));
    }

    protected FileListener getListener() throws Exception {
        FileListener listener = (FileListener)this.listener.get();
        if (listener == null) {
            FileObject file2 = this.fs.resolveFile(this.name);
            file2.getFileSystem().removeListener(file2, this);
        }
        return listener;
    }

    public void fileCreated(FileChangeEvent event) throws Exception {
        FileListener listener = this.getListener();
        if (listener == null) {
            return;
        }
        listener.fileCreated(event);
    }

    public void fileDeleted(FileChangeEvent event) throws Exception {
        FileListener listener = this.getListener();
        if (listener == null) {
            return;
        }
        listener.fileDeleted(event);
    }

    public void fileChanged(FileChangeEvent event) throws Exception {
        FileListener listener = this.getListener();
        if (listener == null) {
            return;
        }
        listener.fileChanged(event);
    }
}

