/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.base;

import java.io.IOException;
import org.renjin.base.Crc64;
import org.renjin.base.StrSignIf;
import org.renjin.eval.Context;
import org.renjin.eval.EvalException;
import org.renjin.invoke.annotations.Current;
import org.renjin.methods.Methods;
import org.renjin.primitives.io.serialization.Serialization;
import org.renjin.primitives.matrix.Matrix;
import org.renjin.primitives.matrix.MatrixBuilder;
import org.renjin.primitives.vector.BinCodeVector;
import org.renjin.sexp.AtomicVector;
import org.renjin.sexp.AttributeMap;
import org.renjin.sexp.DoubleVector;
import org.renjin.sexp.Environment;
import org.renjin.sexp.IntArrayVector;
import org.renjin.sexp.IntVector;
import org.renjin.sexp.ListVector;
import org.renjin.sexp.LogicalVector;
import org.renjin.sexp.Null;
import org.renjin.sexp.PairList;
import org.renjin.sexp.S4Object;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.StringVector;
import org.renjin.sexp.Symbol;
import org.renjin.sexp.Symbols;
import org.renjin.sexp.Vector;

public class Base {
    private Base() {
    }

    public static ListVector R_getSymbolInfo(String sname, SEXP spackage, boolean withRegistrationInfo) {
        ListVector.Builder result = new ListVector.Builder();
        result.setAttribute(Symbols.CLASS, (SEXP)StringVector.valueOf("CRoutine"));
        return result.build();
    }

    public static ListVector R_getRegisteredRoutines(String dll) {
        ListVector.Builder builder = new ListVector.Builder();
        return builder.build();
    }

    public static SEXP R_shortRowNames(SEXP vector2, int type) {
        SEXP s;
        SEXP ans = s = vector2.getAttribute(Symbols.ROW_NAMES);
        if (type < 0 || type > 2) {
            throw new EvalException("invalid 'type' argument", new Object[0]);
        }
        if (type >= 1) {
            int n = s instanceof IntVector && s.length() == 2 && ((IntVector)s).isElementNA(0) ? ((IntVector)s).getElementAsInt(1) : (s == Null.INSTANCE ? 0 : s.length());
            ans = type == 1 ? new IntArrayVector(n) : new IntArrayVector(Math.abs(n));
        }
        return ans;
    }

    public static PairList R_tabulate(IntVector bin, int length2, int nbins, SEXP ans) {
        int[] counts = new int[nbins];
        for (int i = 0; i != length2; ++i) {
            int value;
            if (bin.isElementNA(i) || (value = bin.getElementAsInt(i)) < 1 || value > nbins) continue;
            int n = value - 1;
            counts[n] = counts[n] + 1;
        }
        return PairList.Node.singleton("ans", (SEXP)new IntArrayVector(counts));
    }

    public static SEXP Rrowsum_df(ListVector x, int ncol, Vector group, SEXP ugroup, boolean naRm) {
        throw new EvalException("nyi", new Object[0]);
    }

    public static Vector Rrowsum_matrix(Vector x, int ncol, AtomicVector groups, AtomicVector ugroup, boolean naRm) {
        int numGroups = ugroup.length();
        Matrix source = new Matrix(x, ncol);
        MatrixBuilder result = source.newBuilder(numGroups, ncol);
        for (int col2 = 0; col2 != ncol; ++col2) {
            double[] groupSums = new double[numGroups];
            for (int row2 = 0; row2 != source.getNumRows(); ++row2) {
                int group;
                int n = group = ugroup.indexOf(groups, row2, 0);
                groupSums[n] = groupSums[n] + source.getElementAsDouble(row2, col2);
            }
            for (int group = 0; group != ugroup.length(); ++group) {
                result.setValue(group, col2, groupSums[group]);
            }
        }
        return result.build();
    }

    public static SEXP R_copyDFattr(SEXP in, SEXP out) {
        ListVector attributesToCopy = in.hasAttributes() ? in.getAttributes().toVector() : new ListVector(new SEXP[0]);
        return out.setAttributes(AttributeMap.fromListVector(attributesToCopy));
    }

    public static SEXP R_getVarsFromFrame(@Current Context context, StringVector vars, Environment env2, boolean force) {
        ListVector.NamedBuilder val = new ListVector.NamedBuilder();
        for (String var : vars) {
            SEXP boundValue = env2.getVariable(var);
            if (boundValue == Symbol.UNBOUND_VALUE) {
                throw new EvalException("object %s not found", boundValue);
            }
            if (force) {
                boundValue = boundValue.force(context);
            }
            val.add(var, boundValue);
        }
        return val.build();
    }

    public static ListVector str_signif(Vector x, int n, String type, int width, int digits, String format2, String flag, StringVector resultVector) {
        ListVector.NamedBuilder result = new ListVector.NamedBuilder();
        result.add("result", (SEXP)StrSignIf.str_signif(x, width, digits, format2, flag));
        return result.build();
    }

    public static SEXP R_serialize(@Current Context context, SEXP object2, SEXP connection2, boolean ascii, SEXP version, SEXP refhook) throws IOException {
        return Serialization.serialize(context, object2, connection2, ascii, version, refhook);
    }

    public static SEXP R_unserialize(@Current Context context, SEXP connection2, SEXP refhook) throws IOException {
        return Serialization.unserialize(context, connection2, refhook);
    }

    public static String crc64ToString(String value) {
        return Crc64.getCrc64(value);
    }

    public static SEXP R_isS4Object(SEXP exp2) {
        if (exp2 instanceof S4Object) {
            return LogicalVector.TRUE;
        }
        if (exp2.getAttribute(Symbols.S4_BIT) != Null.INSTANCE) {
            return LogicalVector.TRUE;
        }
        return LogicalVector.FALSE;
    }

    public static SEXP R_do_new_object(S4Object classRepresentation) {
        return Methods.R_do_new_object(classRepresentation);
    }

    public static ListVector bincode(DoubleVector x, int n, DoubleVector breaks, int nb, IntVector code_, boolean right, boolean include_border, boolean naok) {
        if (!naok && x.indexOfNA() != -1) {
            throw new EvalException("NA's in bincode(NAOK=FALSE)", new Object[0]);
        }
        BinCodeVector codedVector = new BinCodeVector(x, breaks.toDoubleArray(), !right, include_border, AttributeMap.EMPTY);
        ListVector.NamedBuilder result = new ListVector.NamedBuilder();
        result.add("code", (SEXP)codedVector);
        return result.build();
    }
}

