/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.compiler.cfg;

import java.util.List;
import java.util.Set;
import org.renjin.compiler.NotCompilableException;
import org.renjin.compiler.TypeSolver;
import org.renjin.compiler.cfg.BasicBlock;
import org.renjin.compiler.cfg.ControlFlowGraph;
import org.renjin.compiler.cfg.DominanceTree;
import org.renjin.compiler.cfg.UseDefMap;
import org.renjin.compiler.codegen.EmitContext;
import org.renjin.compiler.ir.ValueBounds;
import org.renjin.compiler.ir.exception.InternalCompilerException;
import org.renjin.compiler.ir.ssa.SsaTransformer;
import org.renjin.compiler.ir.tac.IRBody;
import org.renjin.compiler.ir.tac.IRBodyBuilder;
import org.renjin.compiler.ir.tac.IRLabel;
import org.renjin.compiler.ir.tac.RuntimeState;
import org.renjin.compiler.ir.tac.expressions.ReadParam;
import org.renjin.compiler.ir.tac.statements.ReturnStatement;
import org.renjin.compiler.ir.tac.statements.Statement;
import org.renjin.repackaged.asm.Label;
import org.renjin.repackaged.asm.commons.InstructionAdapter;
import org.renjin.repackaged.guava.collect.Lists;
import org.renjin.sexp.Closure;
import org.renjin.sexp.Symbol;

public class InlinedFunction {
    private final RuntimeState runtimeState;
    private final SsaTransformer ssaTransformer;
    private final DominanceTree dTree;
    private final ControlFlowGraph cfg;
    private final UseDefMap useDefMap;
    private final TypeSolver types;
    private final List<ReadParam> params;
    private List<ReturnStatement> returnStatements = Lists.newArrayList();

    public InlinedFunction(RuntimeState parentState, Closure closure, Set<Symbol> arguments) {
        this.runtimeState = new RuntimeState(parentState, closure.getEnclosingEnvironment());
        IRBodyBuilder builder = new IRBodyBuilder(this.runtimeState);
        IRBody body2 = builder.buildFunctionBody(closure, arguments);
        this.cfg = new ControlFlowGraph(body2);
        this.dTree = new DominanceTree(this.cfg);
        this.ssaTransformer = new SsaTransformer(this.cfg, this.dTree);
        this.ssaTransformer.transform();
        this.useDefMap = new UseDefMap(this.cfg);
        this.types = new TypeSolver(this.cfg, this.useDefMap);
        this.params = body2.getParams();
        for (Statement statement : body2.getStatements()) {
            if (!(statement instanceof ReturnStatement)) continue;
            this.returnStatements.add((ReturnStatement)statement);
        }
    }

    public ControlFlowGraph getCfg() {
        return this.cfg;
    }

    public SsaTransformer getSsaTransformer() {
        return this.ssaTransformer;
    }

    public List<ReadParam> getParams() {
        return this.params;
    }

    public void updateParam(int i, ValueBounds argumentBounds) {
        this.params.get(i).updateBounds(argumentBounds);
    }

    public ValueBounds computeBounds() {
        this.types.execute();
        if (this.returnStatements.size() == 1) {
            return this.returnStatements.get(0).getRHS().getValueBounds();
        }
        throw new UnsupportedOperationException("TODO");
    }

    public void writeInline(EmitContext emitContext, InstructionAdapter mv) {
        this.types.verifyFunctionAssumptions(this.runtimeState);
        Label exitLabel = new Label();
        for (BasicBlock basicBlock : this.cfg.getBasicBlocks()) {
            if (basicBlock == this.cfg.getEntry() || basicBlock == this.cfg.getExit()) continue;
            for (IRLabel label : basicBlock.getLabels()) {
                mv.visitLabel(emitContext.getAsmLabel(label));
            }
            for (Statement stmt : basicBlock.getStatements()) {
                try {
                    if (stmt instanceof ReturnStatement) {
                        stmt.getRHS().load(emitContext, mv);
                        mv.goTo(exitLabel);
                        continue;
                    }
                    stmt.emit(emitContext, mv);
                }
                catch (NotCompilableException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new InternalCompilerException("Exception compiling statement " + stmt, e);
                }
            }
        }
        mv.mark(exitLabel);
    }

    public String toString() {
        return this.cfg.toString();
    }

    public TypeSolver getTypes() {
        return this.types;
    }
}

