/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.eval;

import java.util.List;
import org.apache.commons.vfs2.FileSystemManager;
import org.renjin.compiler.pipeline.SimpleVectorPipeliner;
import org.renjin.compiler.pipeline.VectorPipeliner;
import org.renjin.eval.Session;
import org.renjin.primitives.packaging.ClasspathPackageLoader;
import org.renjin.primitives.packaging.PackageLoader;
import org.renjin.repackaged.guava.collect.Lists;
import org.renjin.sexp.FunctionCall;
import org.renjin.sexp.Symbol;
import org.renjin.util.FileSystemUtils;

public class SessionBuilder {
    private boolean loadBasePackage = true;
    private List<String> packagesToLoad = Lists.newArrayList();
    private FileSystemManager fileSystemManager;
    private PackageLoader packageLoader;
    private VectorPipeliner vectorPipeliner;
    private ClassLoader classLoader;

    @Deprecated
    public SessionBuilder withFileSystemManager(FileSystemManager fsm) {
        return this.setFileSystemManager(fsm);
    }

    public SessionBuilder withoutBasePackage() {
        this.loadBasePackage = false;
        return this;
    }

    public SessionBuilder withDefaultPackages() {
        this.packagesToLoad = Session.DEFAULT_PACKAGES;
        return this;
    }

    public SessionBuilder setFileSystemManager(FileSystemManager fileSystemManager) {
        this.fileSystemManager = fileSystemManager;
        return this;
    }

    public SessionBuilder setPackageLoader(PackageLoader packageLoader) {
        this.packageLoader = packageLoader;
        return this;
    }

    public SessionBuilder setVectorPipeliner(VectorPipeliner vectorPipeliner) {
        this.vectorPipeliner = vectorPipeliner;
        return this;
    }

    public SessionBuilder setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
        return this;
    }

    @Deprecated
    public <T> SessionBuilder bind(Class<T> clazz, T instance) {
        if (clazz.equals(FileSystemManager.class)) {
            this.setFileSystemManager((FileSystemManager)instance);
        } else if (clazz.equals(PackageLoader.class)) {
            this.setPackageLoader((PackageLoader)instance);
        } else if (clazz.equals(VectorPipeliner.class)) {
            this.setVectorPipeliner((VectorPipeliner)instance);
        } else if (clazz.equals(ClassLoader.class)) {
            this.setClassLoader((ClassLoader)instance);
        }
        return this;
    }

    public Session build() {
        try {
            if (this.fileSystemManager == null) {
                this.fileSystemManager = FileSystemUtils.getMinimalFileSystemManager();
            }
            if (this.classLoader == null) {
                this.classLoader = this.getClass().getClassLoader();
            }
            if (this.vectorPipeliner == null) {
                this.vectorPipeliner = new SimpleVectorPipeliner();
            }
            if (this.packageLoader == null) {
                this.packageLoader = new ClasspathPackageLoader(this.classLoader);
            }
            Session session = new Session(this.fileSystemManager, this.classLoader, this.packageLoader, this.vectorPipeliner);
            if (this.loadBasePackage) {
                session.getTopLevelContext().init();
            }
            for (String packageToLoad : this.packagesToLoad) {
                session.getTopLevelContext().evaluate(FunctionCall.newCall(Symbol.get("library"), Symbol.get(packageToLoad)));
            }
            return session;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Session buildDefault() {
        return new SessionBuilder().build();
    }
}

