/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.gcc.runtime;

import java.util.Arrays;
import org.renjin.gcc.runtime.MallocThunk;
import org.renjin.gcc.runtime.Ptr;
import org.renjin.gcc.runtime.Realloc;

public class IntPtr
implements Ptr {
    public static final int BYTES = 4;
    public static final IntPtr NULL = new IntPtr();
    public final int[] array;
    public final int offset;

    private IntPtr() {
        this.array = null;
        this.offset = 0;
    }

    public IntPtr(int[] array2, int offset) {
        this.array = array2;
        this.offset = offset;
    }

    public IntPtr(int ... array2) {
        this.array = array2;
        this.offset = 0;
    }

    public int[] getArray() {
        return this.array;
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    @Override
    public IntPtr realloc(int newSizeInBytes) {
        return new IntPtr(Realloc.realloc(this.array, this.offset, newSizeInBytes / 4));
    }

    @Override
    public Ptr pointerPlus(int bytes) {
        return new IntPtr(this.array, this.offset + bytes / 4);
    }

    public int unwrap() {
        return this.array[this.offset];
    }

    public int get() {
        return this.array[this.offset];
    }

    public void set(int value) {
        this.array[this.offset] = value;
    }

    public String toString() {
        return this.offset + "+" + Arrays.toString(this.array);
    }

    public static void memset(int[] str, int strOffset, int byteValue, int n) {
        assert (n % 4 == 0);
        Arrays.fill(str, strOffset, strOffset + n / 4, IntPtr.memset(byteValue));
    }

    public static int memset(int byteValue) {
        return byteValue << 24 | (byteValue & 0xFF) << 16 | (byteValue & 0xFF) << 8 | byteValue & 0xFF;
    }

    public static int memcmp(IntPtr x, IntPtr y, int n) {
        return IntPtr.memcmp(x.array, x.offset, y.array, y.offset, n);
    }

    public static int memcmp(int[] x, int xi, int[] y, int yi, int n) {
        while (n > 0) {
            int vx = x[xi];
            int vy = y[yi];
            if (vx != vy || n < 4) {
                return IntPtr.memcmp(vx, vy, n);
            }
            ++xi;
            ++yi;
            n -= 4;
        }
        return 0;
    }

    public static int memcmp(int x, int y, int n) {
        for (int i = 0; i < n; ++i) {
            int xb = (int)((long)x & 0xFFL);
            int yb = (int)((long)y & 0xFFL);
            if (xb < yb) {
                return -1;
            }
            if (xb > yb) {
                return 1;
            }
            x >>= 8;
            y >>= 8;
        }
        return 0;
    }

    public static IntPtr cast(Object voidPointer) {
        if (voidPointer instanceof MallocThunk) {
            return ((MallocThunk)voidPointer).intPtr();
        }
        if (voidPointer == null) {
            return NULL;
        }
        return (IntPtr)voidPointer;
    }
}

