/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.gcc.runtime;

import java.util.Arrays;
import org.renjin.gcc.annotations.GccSize;
import org.renjin.gcc.runtime.BooleanPtr;
import org.renjin.gcc.runtime.BytePtr;
import org.renjin.gcc.runtime.CharPtr;
import org.renjin.gcc.runtime.DoublePtr;
import org.renjin.gcc.runtime.FloatPtr;
import org.renjin.gcc.runtime.IntPtr;
import org.renjin.gcc.runtime.LongPtr;
import org.renjin.gcc.runtime.MallocThunk;
import org.renjin.gcc.runtime.Ptr;
import org.renjin.gcc.runtime.Realloc;
import org.renjin.gcc.runtime.ShortPtr;

public class ObjectPtr<T>
implements Ptr {
    public static final ObjectPtr NULL = new ObjectPtr();
    public final Object[] array;
    public final int offset;
    public Class baseType;

    private ObjectPtr() {
        this.array = null;
        this.offset = 0;
    }

    public ObjectPtr(T ... array2) {
        this.array = array2;
        this.offset = 0;
    }

    public ObjectPtr(Object[] array2, int offset) {
        this.array = array2;
        this.offset = offset;
    }

    public ObjectPtr(Class baseType, Object[] array2, int offset) {
        this.array = array2;
        this.offset = offset;
        this.baseType = baseType;
    }

    public Object[] getArray() {
        return this.array;
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    @Override
    public ObjectPtr<T> realloc(int newSizeInBytes) {
        return new ObjectPtr<Object>(Realloc.realloc(this.array, this.offset, newSizeInBytes / 4));
    }

    @Override
    public Ptr pointerPlus(int bytes) {
        throw new UnsupportedOperationException("TODO");
    }

    public T get() {
        return this.get(0);
    }

    public void set(Object value) {
        if (value instanceof MallocThunk) {
            MallocThunk thunk = (MallocThunk)value;
            this.array[this.offset] = this.array instanceof BooleanPtr[] || BooleanPtr.class.equals((Object)this.baseType) ? thunk.booleanPtr() : (this.array instanceof BytePtr[] || BytePtr.class.equals((Object)this.baseType) ? thunk.bytePtr() : (this.array instanceof CharPtr[] || CharPtr.class.equals((Object)this.baseType) ? thunk.charPtr() : (this.array instanceof DoublePtr[] || DoublePtr.class.equals((Object)this.baseType) ? thunk.doublePtr() : (this.array instanceof FloatPtr[] || FloatPtr.class.equals((Object)this.baseType) ? thunk.floatPtr() : (this.array instanceof IntPtr[] || IntPtr.class.equals((Object)this.baseType) ? thunk.intPtr() : (this.array instanceof LongPtr[] || LongPtr.class.equals((Object)this.baseType) ? thunk.longPtr() : (this.array instanceof ShortPtr[] || ShortPtr.class.equals((Object)this.baseType) ? thunk.shortPtr() : (this.array instanceof ObjectPtr[] ? thunk.objectPtr(this.baseType) : thunk.recordUnitPtr(this.array.getClass().getComponentType())))))))));
        } else {
            this.array[this.offset] = value;
        }
    }

    public T get(int index) {
        return (T)this.array[this.offset + index];
    }

    public static void memset(Object[] str, int strOffset, int c2, int byteCount) {
        Object nullInstance;
        if (byteCount == 0) {
            return;
        }
        Class<?> elementType = str.getClass().getComponentType();
        if (Ptr.class.isAssignableFrom(elementType)) {
            try {
                nullInstance = elementType.getField("NULL").get(null);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                throw new IllegalStateException("Cannot access NULL instance for " + elementType.getName());
            }
        } else {
            GccSize size = elementType.getAnnotation(GccSize.class);
            if (size == null) {
                throw new IllegalStateException(elementType.getClass().getName() + " is missing @GccSize annotation");
            }
            int numElements = byteCount / size.value();
            throw new UnsupportedOperationException("TODO");
        }
        Arrays.fill(str, strOffset, strOffset + byteCount / 4, nullInstance);
    }

    public static ObjectPtr cast(Object voidPointer) {
        if (voidPointer instanceof MallocThunk) {
            throw new UnsupportedOperationException("Casting of void* to record type without type information. Please recompile against the latest version of gcc-bridge to resolve.");
        }
        return (ObjectPtr)voidPointer;
    }

    public static ObjectPtr cast(Object voidPointer, Class<?> recordType) {
        if (voidPointer instanceof MallocThunk) {
            return ((MallocThunk)voidPointer).objectPtr(recordType);
        }
        return (ObjectPtr)voidPointer;
    }

    public static <T> T castUnit(Object voidPointer, Class<T> recordType) {
        if (voidPointer instanceof MallocThunk) {
            return ((MallocThunk)voidPointer).recordUnitPtr(recordType);
        }
        return (T)recordType;
    }
}

