/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.gnur.api;

import org.apache.commons.math.util.FastMath;
import org.renjin.gcc.runtime.DoublePtr;
import org.renjin.gcc.runtime.IntPtr;
import org.renjin.gnur.api.Random;
import org.renjin.gnur.api.UnimplementedGnuApiMethod;
import org.renjin.sexp.DoubleVector;
import org.renjin.sexp.IntVector;

public final class Rmath {
    private Rmath() {
    }

    public static double R_pow(double x, double y) {
        return FastMath.pow(x, y);
    }

    public static double R_pow_di(double x, int n) {
        double xn = 1.0;
        if (Double.isNaN(x)) {
            return x;
        }
        if (IntVector.isNA(n)) {
            return DoubleVector.NA;
        }
        if (n != 0) {
            boolean isNegative;
            if (!DoubleVector.isFinite(x)) {
                return Rmath.R_pow(x, n);
            }
            boolean bl = isNegative = n < 0;
            if (isNegative) {
                n = -n;
            }
            while (true) {
                if ((n & 1) != 0) {
                    xn *= x;
                }
                if ((n >>= 1) == 0) break;
                x *= x;
            }
            if (isNegative) {
                xn = 1.0 / xn;
            }
        }
        return xn;
    }

    public static double norm_rand() {
        throw new UnimplementedGnuApiMethod("norm_rand");
    }

    @Deprecated
    public static double unif_rand() {
        return Random.unif_rand();
    }

    public static double exp_rand() {
        throw new UnimplementedGnuApiMethod("exp_rand");
    }

    public static double Rf_dnorm4(double p0, double p1, double p2, int p3) {
        throw new UnimplementedGnuApiMethod("Rf_dnorm4");
    }

    public static double Rf_pnorm5(double p0, double p1, double p2, int p3, int p4) {
        throw new UnimplementedGnuApiMethod("Rf_pnorm5");
    }

    public static double Rf_qnorm5(double p0, double p1, double p2, int p3, int p4) {
        throw new UnimplementedGnuApiMethod("Rf_qnorm5");
    }

    public static double Rf_rnorm(double p0, double p1) {
        throw new UnimplementedGnuApiMethod("Rf_rnorm");
    }

    public static void Rf_pnorm_both(double p0, DoublePtr p1, DoublePtr p2, int p3, int p4) {
        throw new UnimplementedGnuApiMethod("Rf_pnorm_both");
    }

    public static double Rf_dunif(double p0, double p1, double p2, int p3) {
        throw new UnimplementedGnuApiMethod("Rf_dunif");
    }

    public static double Rf_punif(double p0, double p1, double p2, int p3, int p4) {
        throw new UnimplementedGnuApiMethod("Rf_punif");
    }

    public static double Rf_qunif(double p0, double p1, double p2, int p3, int p4) {
        throw new UnimplementedGnuApiMethod("Rf_qunif");
    }

    public static double Rf_runif(double p0, double p1) {
        throw new UnimplementedGnuApiMethod("Rf_runif");
    }

    public static double Rf_dgamma(double p0, double p1, double p2, int p3) {
        throw new UnimplementedGnuApiMethod("Rf_dgamma");
    }

    public static double Rf_pgamma(double p0, double p1, double p2, int p3, int p4) {
        throw new UnimplementedGnuApiMethod("Rf_pgamma");
    }

    public static double Rf_qgamma(double p0, double p1, double p2, int p3, int p4) {
        throw new UnimplementedGnuApiMethod("Rf_qgamma");
    }

    public static double Rf_rgamma(double p0, double p1) {
        throw new UnimplementedGnuApiMethod("Rf_rgamma");
    }

    public static double Rf_log1pmx(double p0) {
        throw new UnimplementedGnuApiMethod("Rf_log1pmx");
    }

    public static double log1pexp(double p0) {
        throw new UnimplementedGnuApiMethod("log1pexp");
    }

    public static double Rf_lgamma1p(double p0) {
        throw new UnimplementedGnuApiMethod("Rf_lgamma1p");
    }

    public static double Rf_logspace_add(double p0, double p1) {
        throw new UnimplementedGnuApiMethod("Rf_logspace_add");
    }

    public static double Rf_logspace_sub(double p0, double p1) {
        throw new UnimplementedGnuApiMethod("Rf_logspace_sub");
    }

    public static double logspace_sum(DoublePtr p0, int p1) {
        throw new UnimplementedGnuApiMethod("logspace_sum");
    }

    public static double Rf_dbeta(double p0, double p1, double p2, int p3) {
        throw new UnimplementedGnuApiMethod("Rf_dbeta");
    }

    public static double Rf_pbeta(double p0, double p1, double p2, int p3, int p4) {
        throw new UnimplementedGnuApiMethod("Rf_pbeta");
    }

    public static double Rf_qbeta(double p0, double p1, double p2, int p3, int p4) {
        throw new UnimplementedGnuApiMethod("Rf_qbeta");
    }

    public static double Rf_rbeta(double p0, double p1) {
        throw new UnimplementedGnuApiMethod("Rf_rbeta");
    }

    public static double Rf_dlnorm(double p0, double p1, double p2, int p3) {
        throw new UnimplementedGnuApiMethod("Rf_dlnorm");
    }

    public static double Rf_plnorm(double p0, double p1, double p2, int p3, int p4) {
        throw new UnimplementedGnuApiMethod("Rf_plnorm");
    }

    public static double Rf_qlnorm(double p0, double p1, double p2, int p3, int p4) {
        throw new UnimplementedGnuApiMethod("Rf_qlnorm");
    }

    public static double Rf_rlnorm(double p0, double p1) {
        throw new UnimplementedGnuApiMethod("Rf_rlnorm");
    }

    public static double Rf_dchisq(double p0, double p1, int p2) {
        throw new UnimplementedGnuApiMethod("Rf_dchisq");
    }

    public static double Rf_pchisq(double p0, double p1, int p2, int p3) {
        throw new UnimplementedGnuApiMethod("Rf_pchisq");
    }

    public static double Rf_qchisq(double p0, double p1, int p2, int p3) {
        throw new UnimplementedGnuApiMethod("Rf_qchisq");
    }

    public static double Rf_rchisq(double p0) {
        throw new UnimplementedGnuApiMethod("Rf_rchisq");
    }

    public static double Rf_dnchisq(double p0, double p1, double p2, int p3) {
        throw new UnimplementedGnuApiMethod("Rf_dnchisq");
    }

    public static double Rf_pnchisq(double p0, double p1, double p2, int p3, int p4) {
        throw new UnimplementedGnuApiMethod("Rf_pnchisq");
    }

    public static double Rf_qnchisq(double p0, double p1, double p2, int p3, int p4) {
        throw new UnimplementedGnuApiMethod("Rf_qnchisq");
    }

    public static double Rf_rnchisq(double p0, double p1) {
        throw new UnimplementedGnuApiMethod("Rf_rnchisq");
    }

    public static double Rf_df(double p0, double p1, double p2, int p3) {
        throw new UnimplementedGnuApiMethod("Rf_df");
    }

    public static double Rf_pf(double p0, double p1, double p2, int p3, int p4) {
        throw new UnimplementedGnuApiMethod("Rf_pf");
    }

    public static double Rf_qf(double p0, double p1, double p2, int p3, int p4) {
        throw new UnimplementedGnuApiMethod("Rf_qf");
    }

    public static double Rf_rf(double p0, double p1) {
        throw new UnimplementedGnuApiMethod("Rf_rf");
    }

    public static double Rf_dt(double p0, double p1, int p2) {
        throw new UnimplementedGnuApiMethod("Rf_dt");
    }

    public static double Rf_pt(double p0, double p1, int p2, int p3) {
        throw new UnimplementedGnuApiMethod("Rf_pt");
    }

    public static double Rf_qt(double p0, double p1, int p2, int p3) {
        throw new UnimplementedGnuApiMethod("Rf_qt");
    }

    public static double Rf_rt(double p0) {
        throw new UnimplementedGnuApiMethod("Rf_rt");
    }

    public static double Rf_dbinom_raw(double x, double n, double p, double q, int give_log) {
        throw new UnimplementedGnuApiMethod("Rf_dbinom_raw");
    }

    public static double Rf_dbinom(double p0, double p1, double p2, int p3) {
        throw new UnimplementedGnuApiMethod("Rf_dbinom");
    }

    public static double Rf_pbinom(double p0, double p1, double p2, int p3, int p4) {
        throw new UnimplementedGnuApiMethod("Rf_pbinom");
    }

    public static double Rf_qbinom(double p0, double p1, double p2, int p3, int p4) {
        throw new UnimplementedGnuApiMethod("Rf_qbinom");
    }

    public static double Rf_rbinom(double p0, double p1) {
        throw new UnimplementedGnuApiMethod("Rf_rbinom");
    }

    public static void Rf_rmultinom(int p0, DoublePtr p1, int p2, IntPtr p3) {
        throw new UnimplementedGnuApiMethod("Rf_rmultinom");
    }

    public static double Rf_dcauchy(double p0, double p1, double p2, int p3) {
        throw new UnimplementedGnuApiMethod("Rf_dcauchy");
    }

    public static double Rf_pcauchy(double p0, double p1, double p2, int p3, int p4) {
        throw new UnimplementedGnuApiMethod("Rf_pcauchy");
    }

    public static double Rf_qcauchy(double p0, double p1, double p2, int p3, int p4) {
        throw new UnimplementedGnuApiMethod("Rf_qcauchy");
    }

    public static double Rf_rcauchy(double p0, double p1) {
        throw new UnimplementedGnuApiMethod("Rf_rcauchy");
    }

    public static double Rf_dexp(double p0, double p1, int p2) {
        throw new UnimplementedGnuApiMethod("Rf_dexp");
    }

    public static double Rf_pexp(double p0, double p1, int p2, int p3) {
        throw new UnimplementedGnuApiMethod("Rf_pexp");
    }

    public static double Rf_qexp(double p0, double p1, int p2, int p3) {
        throw new UnimplementedGnuApiMethod("Rf_qexp");
    }

    public static double Rf_rexp(double p0) {
        throw new UnimplementedGnuApiMethod("Rf_rexp");
    }

    public static double Rf_dgeom(double p0, double p1, int p2) {
        throw new UnimplementedGnuApiMethod("Rf_dgeom");
    }

    public static double Rf_pgeom(double p0, double p1, int p2, int p3) {
        throw new UnimplementedGnuApiMethod("Rf_pgeom");
    }

    public static double Rf_qgeom(double p0, double p1, int p2, int p3) {
        throw new UnimplementedGnuApiMethod("Rf_qgeom");
    }

    public static double Rf_rgeom(double p0) {
        throw new UnimplementedGnuApiMethod("Rf_rgeom");
    }

    public static double Rf_dhyper(double p0, double p1, double p2, double p3, int p4) {
        throw new UnimplementedGnuApiMethod("Rf_dhyper");
    }

    public static double Rf_phyper(double p0, double p1, double p2, double p3, int p4, int p5) {
        throw new UnimplementedGnuApiMethod("Rf_phyper");
    }

    public static double Rf_qhyper(double p0, double p1, double p2, double p3, int p4, int p5) {
        throw new UnimplementedGnuApiMethod("Rf_qhyper");
    }

    public static double Rf_rhyper(double p0, double p1, double p2) {
        throw new UnimplementedGnuApiMethod("Rf_rhyper");
    }

    public static double Rf_dnbinom(double p0, double p1, double p2, int p3) {
        throw new UnimplementedGnuApiMethod("Rf_dnbinom");
    }

    public static double Rf_pnbinom(double p0, double p1, double p2, int p3, int p4) {
        throw new UnimplementedGnuApiMethod("Rf_pnbinom");
    }

    public static double Rf_qnbinom(double p0, double p1, double p2, int p3, int p4) {
        throw new UnimplementedGnuApiMethod("Rf_qnbinom");
    }

    public static double Rf_rnbinom(double p0, double p1) {
        throw new UnimplementedGnuApiMethod("Rf_rnbinom");
    }

    public static double Rf_dnbinom_mu(double p0, double p1, double p2, int p3) {
        throw new UnimplementedGnuApiMethod("Rf_dnbinom_mu");
    }

    public static double Rf_pnbinom_mu(double p0, double p1, double p2, int p3, int p4) {
        throw new UnimplementedGnuApiMethod("Rf_pnbinom_mu");
    }

    public static double Rf_qnbinom_mu(double p0, double p1, double p2, int p3, int p4) {
        throw new UnimplementedGnuApiMethod("Rf_qnbinom_mu");
    }

    public static double Rf_rnbinom_mu(double p0, double p1) {
        throw new UnimplementedGnuApiMethod("Rf_rnbinom_mu");
    }

    public static double Rf_dpois_raw(double p0, double p1, int p2) {
        throw new UnimplementedGnuApiMethod("Rf_dpois_raw");
    }

    public static double Rf_dpois(double p0, double p1, int p2) {
        throw new UnimplementedGnuApiMethod("Rf_dpois");
    }

    public static double Rf_ppois(double p0, double p1, int p2, int p3) {
        throw new UnimplementedGnuApiMethod("Rf_ppois");
    }

    public static double Rf_qpois(double p0, double p1, int p2, int p3) {
        throw new UnimplementedGnuApiMethod("Rf_qpois");
    }

    public static double Rf_rpois(double p0) {
        throw new UnimplementedGnuApiMethod("Rf_rpois");
    }

    public static double Rf_dweibull(double p0, double p1, double p2, int p3) {
        throw new UnimplementedGnuApiMethod("Rf_dweibull");
    }

    public static double Rf_pweibull(double p0, double p1, double p2, int p3, int p4) {
        throw new UnimplementedGnuApiMethod("Rf_pweibull");
    }

    public static double Rf_qweibull(double p0, double p1, double p2, int p3, int p4) {
        throw new UnimplementedGnuApiMethod("Rf_qweibull");
    }

    public static double Rf_rweibull(double p0, double p1) {
        throw new UnimplementedGnuApiMethod("Rf_rweibull");
    }

    public static double Rf_dlogis(double p0, double p1, double p2, int p3) {
        throw new UnimplementedGnuApiMethod("Rf_dlogis");
    }

    public static double Rf_plogis(double p0, double p1, double p2, int p3, int p4) {
        throw new UnimplementedGnuApiMethod("Rf_plogis");
    }

    public static double Rf_qlogis(double p0, double p1, double p2, int p3, int p4) {
        throw new UnimplementedGnuApiMethod("Rf_qlogis");
    }

    public static double Rf_rlogis(double p0, double p1) {
        throw new UnimplementedGnuApiMethod("Rf_rlogis");
    }

    public static double Rf_dnbeta(double p0, double p1, double p2, double p3, int p4) {
        throw new UnimplementedGnuApiMethod("Rf_dnbeta");
    }

    public static double Rf_pnbeta(double p0, double p1, double p2, double p3, int p4, int p5) {
        throw new UnimplementedGnuApiMethod("Rf_pnbeta");
    }

    public static double Rf_qnbeta(double p0, double p1, double p2, double p3, int p4, int p5) {
        throw new UnimplementedGnuApiMethod("Rf_qnbeta");
    }

    public static double Rf_rnbeta(double p0, double p1, double p2) {
        throw new UnimplementedGnuApiMethod("Rf_rnbeta");
    }

    public static double Rf_dnf(double p0, double p1, double p2, double p3, int p4) {
        throw new UnimplementedGnuApiMethod("Rf_dnf");
    }

    public static double Rf_pnf(double p0, double p1, double p2, double p3, int p4, int p5) {
        throw new UnimplementedGnuApiMethod("Rf_pnf");
    }

    public static double Rf_qnf(double p0, double p1, double p2, double p3, int p4, int p5) {
        throw new UnimplementedGnuApiMethod("Rf_qnf");
    }

    public static double Rf_dnt(double p0, double p1, double p2, int p3) {
        throw new UnimplementedGnuApiMethod("Rf_dnt");
    }

    public static double Rf_pnt(double p0, double p1, double p2, int p3, int p4) {
        throw new UnimplementedGnuApiMethod("Rf_pnt");
    }

    public static double Rf_qnt(double p0, double p1, double p2, int p3, int p4) {
        throw new UnimplementedGnuApiMethod("Rf_qnt");
    }

    public static double Rf_ptukey(double p0, double p1, double p2, double p3, int p4, int p5) {
        throw new UnimplementedGnuApiMethod("Rf_ptukey");
    }

    public static double Rf_qtukey(double p0, double p1, double p2, double p3, int p4, int p5) {
        throw new UnimplementedGnuApiMethod("Rf_qtukey");
    }

    public static double Rf_dwilcox(double p0, double p1, double p2, int p3) {
        throw new UnimplementedGnuApiMethod("Rf_dwilcox");
    }

    public static double Rf_pwilcox(double p0, double p1, double p2, int p3, int p4) {
        throw new UnimplementedGnuApiMethod("Rf_pwilcox");
    }

    public static double Rf_qwilcox(double p0, double p1, double p2, int p3, int p4) {
        throw new UnimplementedGnuApiMethod("Rf_qwilcox");
    }

    public static double Rf_rwilcox(double p0, double p1) {
        throw new UnimplementedGnuApiMethod("Rf_rwilcox");
    }

    public static double Rf_dsignrank(double p0, double p1, int p2) {
        throw new UnimplementedGnuApiMethod("Rf_dsignrank");
    }

    public static double Rf_psignrank(double p0, double p1, int p2, int p3) {
        throw new UnimplementedGnuApiMethod("Rf_psignrank");
    }

    public static double Rf_qsignrank(double p0, double p1, int p2, int p3) {
        throw new UnimplementedGnuApiMethod("Rf_qsignrank");
    }

    public static double Rf_rsignrank(double p0) {
        throw new UnimplementedGnuApiMethod("Rf_rsignrank");
    }

    public static double Rf_gammafn(double p0) {
        throw new UnimplementedGnuApiMethod("Rf_gammafn");
    }

    public static double Rf_lgammafn(double p0) {
        throw new UnimplementedGnuApiMethod("Rf_lgammafn");
    }

    public static double Rf_lgammafn_sign(double p0, IntPtr p1) {
        throw new UnimplementedGnuApiMethod("Rf_lgammafn_sign");
    }

    public static void Rf_dpsifn(double p0, int p1, int p2, int p3, DoublePtr p4, IntPtr p5, IntPtr p6) {
        throw new UnimplementedGnuApiMethod("Rf_dpsifn");
    }

    public static double Rf_psigamma(double p0, double p1) {
        throw new UnimplementedGnuApiMethod("Rf_psigamma");
    }

    public static double Rf_digamma(double p0) {
        throw new UnimplementedGnuApiMethod("Rf_digamma");
    }

    public static double Rf_trigamma(double p0) {
        throw new UnimplementedGnuApiMethod("Rf_trigamma");
    }

    public static double Rf_tetragamma(double p0) {
        throw new UnimplementedGnuApiMethod("Rf_tetragamma");
    }

    public static double Rf_pentagamma(double p0) {
        throw new UnimplementedGnuApiMethod("Rf_pentagamma");
    }

    public static double Rf_beta(double p0, double p1) {
        throw new UnimplementedGnuApiMethod("Rf_beta");
    }

    public static double Rf_lbeta(double p0, double p1) {
        throw new UnimplementedGnuApiMethod("Rf_lbeta");
    }

    public static double Rf_choose(double p0, double p1) {
        throw new UnimplementedGnuApiMethod("Rf_choose");
    }

    public static double Rf_lchoose(double p0, double p1) {
        throw new UnimplementedGnuApiMethod("Rf_lchoose");
    }

    public static double Rf_bessel_i(double p0, double p1, double p2) {
        throw new UnimplementedGnuApiMethod("Rf_bessel_i");
    }

    public static double Rf_bessel_j(double p0, double p1) {
        throw new UnimplementedGnuApiMethod("Rf_bessel_j");
    }

    public static double Rf_bessel_k(double p0, double p1, double p2) {
        throw new UnimplementedGnuApiMethod("Rf_bessel_k");
    }

    public static double Rf_bessel_y(double p0, double p1) {
        throw new UnimplementedGnuApiMethod("Rf_bessel_y");
    }

    public static double Rf_bessel_i_ex(double p0, double p1, double p2, DoublePtr p3) {
        throw new UnimplementedGnuApiMethod("Rf_bessel_i_ex");
    }

    public static double Rf_bessel_j_ex(double p0, double p1, DoublePtr p2) {
        throw new UnimplementedGnuApiMethod("Rf_bessel_j_ex");
    }

    public static double Rf_bessel_k_ex(double p0, double p1, double p2, DoublePtr p3) {
        throw new UnimplementedGnuApiMethod("Rf_bessel_k_ex");
    }

    public static double Rf_bessel_y_ex(double p0, double p1, DoublePtr p2) {
        throw new UnimplementedGnuApiMethod("Rf_bessel_y_ex");
    }

    public static double Rf_pythag(double p0, double p1) {
        throw new UnimplementedGnuApiMethod("Rf_pythag");
    }

    public static int Rf_imax2(int x, int y) {
        return x < y ? y : x;
    }

    public static int Rf_imin2(int x, int y) {
        return x < y ? x : y;
    }

    public static double Rf_fmax2(double x, double y) {
        if (Double.isNaN(x) || Double.isNaN(y)) {
            return x + y;
        }
        return Math.max(x, y);
    }

    public static double Rf_fmin2(double x, double y) {
        if (Double.isNaN(x) || Double.isNaN(y)) {
            return x + y;
        }
        return Math.min(x, y);
    }

    public static double Rf_sign(double p0) {
        if (DoubleVector.isNaN(p0)) {
            return p0;
        }
        return p0 > 0.0 ? 1 : (p0 == 0.0 ? 0 : -1);
    }

    public static double Rf_fprec(double p0, double p1) {
        throw new UnimplementedGnuApiMethod("Rf_fprec");
    }

    public static double Rf_fround(double p0, double p1) {
        throw new UnimplementedGnuApiMethod("Rf_fround");
    }

    public static double Rf_fsign(double p0, double p1) {
        throw new UnimplementedGnuApiMethod("Rf_fsign");
    }

    public static double Rf_ftrunc(double p0) {
        throw new UnimplementedGnuApiMethod("Rf_ftrunc");
    }

    public static double cospi(double p0) {
        throw new UnimplementedGnuApiMethod("cospi");
    }

    public static double sinpi(double p0) {
        throw new UnimplementedGnuApiMethod("sinpi");
    }

    public static double tanpi(double p0) {
        throw new UnimplementedGnuApiMethod("tanpi");
    }
}

