/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.invoke.reflection;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.renjin.eval.EvalException;
import org.renjin.invoke.reflection.MemberBinding;
import org.renjin.invoke.reflection.converters.Converter;
import org.renjin.invoke.reflection.converters.Converters;
import org.renjin.sexp.SEXP;

public class FieldBinding
implements MemberBinding {
    private final Field field;
    private final Converter converter;

    public FieldBinding(Field field) {
        this.field = field;
        this.converter = Converters.get(field.getType());
    }

    @Override
    public SEXP getValue(Object instance) {
        try {
            return this.converter.convertToR(this.field.get(instance));
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Exception reading value of field " + this.field, e);
        }
    }

    @Override
    public void setValue(Object instance, SEXP value) {
        if (!Modifier.isFinal(this.field.getModifiers())) {
            throw new EvalException("The static field '%s' is read-only", this.field.toString());
        }
        try {
            this.field.set(instance, this.converter.convertToJava(value));
        }
        catch (IllegalAccessException e) {
            throw new EvalException("Exception setting field " + this.field.toString(), e);
        }
    }
}

