/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.invoke.reflection.converters;

import org.renjin.invoke.reflection.converters.Converter;
import org.renjin.sexp.AtomicVector;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.StringArrayVector;
import org.renjin.sexp.StringVector;

public class StringArrayConverter
implements Converter<String[]> {
    public static final Converter INSTANCE = new StringArrayConverter();

    private StringArrayConverter() {
    }

    public static boolean accept(Class clazz) {
        return clazz.isArray() && clazz.getComponentType() == String.class;
    }

    @Override
    public SEXP convertToR(String[] value) {
        return new StringArrayVector(value);
    }

    @Override
    public boolean acceptsSEXP(SEXP exp2) {
        return exp2 instanceof StringVector;
    }

    @Override
    public Object convertToJava(SEXP value) {
        AtomicVector vector2 = (AtomicVector)value;
        String[] array2 = new String[value.length()];
        for (int i = 0; i != value.length(); ++i) {
            array2[i] = vector2.getElementAsString(i);
        }
        return array2;
    }

    @Override
    public int getSpecificity() {
        return 10;
    }
}

