/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.invoke.reflection.converters;

import org.renjin.invoke.reflection.converters.BoxedScalarConverter;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.StringVector;
import org.renjin.sexp.Vector;

public class StringConverter
extends BoxedScalarConverter<String> {
    public static final StringConverter INSTANCE = new StringConverter();

    private StringConverter() {
    }

    public static boolean accept(Class clazz) {
        if (clazz.isArray()) {
            return false;
        }
        return clazz == String.class;
    }

    @Override
    public SEXP convertToR(String value) {
        return StringVector.valueOf(value);
    }

    @Override
    protected Object getFirstElement(Vector value) {
        return value.getElementAsString(0);
    }

    @Override
    public boolean acceptsSEXP(SEXP exp2) {
        return exp2 instanceof Vector && ((Vector)exp2).length() == 1;
    }

    @Override
    public int getSpecificity() {
        return 4;
    }

    @Override
    public Vector.Type getVectorType() {
        return StringVector.VECTOR_TYPE;
    }
}

