/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.nmath;

import org.renjin.gcc.runtime.Builtins;
import org.renjin.gcc.runtime.Mathlib;

public class cospi {
    private cospi() {
    }

    public static double tanpi(double d) {
        double d2;
        if (Builtins.__isnan(d) != 0) {
            d2 = d;
        } else if (Builtins.__finite(d) == 0) {
            d2 = 0.0 / 0.0;
        } else {
            double iftmp$0;
            d = Mathlib.fmod(d, 1.0);
            if (d <= -0.5) {
                d += 1.0;
            } else if (d > 0.5) {
                d -= 1.0;
            }
            if (d != 0.0) {
                double iftmp$1 = d != 0.5 ? Mathlib.tan(d * Math.PI) : 0.0 / 0.0;
                iftmp$0 = iftmp$1;
            } else {
                iftmp$0 = 0.0;
            }
            d2 = iftmp$0;
        }
        return d2;
    }

    public static double sinpi(double d) {
        double d2;
        if (Builtins.__isnan(d) != 0) {
            d2 = d;
        } else if (Builtins.__finite(d) == 0) {
            d2 = 0.0 / 0.0;
        } else {
            d = Mathlib.fmod(d, 2.0);
            if (d <= -1.0) {
                d += 2.0;
            } else if (d > 1.0) {
                d -= 2.0;
            }
            d2 = d == 0.0 || d == 1.0 ? 0.0 : (d == 0.5 ? 1.0 : (d == -0.5 ? -1.0 : Mathlib.sin(d * Math.PI)));
        }
        return d2;
    }

    public static double cospi(double d) {
        double d2;
        if (Builtins.__isnan(d) != 0) {
            d2 = d;
        } else if (Builtins.__finite(d) == 0) {
            d2 = 0.0 / 0.0;
        } else {
            d = Mathlib.fmod(Math.abs(d), 2.0);
            d2 = Mathlib.fmod(d, 1.0) == 0.5 ? 0.0 : (d == 1.0 ? -1.0 : (d == 0.0 ? 1.0 : Mathlib.cos(d * Math.PI)));
        }
        return d2;
    }
}

