/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.nmath;

import org.renjin.gcc.runtime.Builtins;
import org.renjin.gcc.runtime.Mathlib;
import org.renjin.nmath.dgamma;
import org.renjin.nmath.dnbeta;
import org.renjin.nmath.dnchisq;

public class dnf {
    private dnf() {
    }

    public static double dnf(double d, double d2, double d3, double d4, int n) {
        double d5;
        if (Builtins.__isnan(d) != 0 || Builtins.__isnan(d2) != 0 || Builtins.__isnan(d3) != 0 || Builtins.__isnan(d4) != 0) {
            d5 = d + d3 + d2 + d4;
        } else if (d2 <= 0.0 || d3 <= 0.0 || d4 < 0.0) {
            d5 = 0.0 / 0.0;
        } else if (d < 0.0) {
            double iftmp$0 = n != 0 ? -1.0 / 0.0 : 0.0;
            d5 = iftmp$0;
        } else if (Builtins.__finite(d4) == 0) {
            d5 = 0.0 / 0.0;
        } else if (Builtins.__finite(d2) == 0 && Builtins.__finite(d3) == 0) {
            if (d == 1.0) {
                d5 = 1.0 / 0.0;
            } else {
                double iftmp$1 = n != 0 ? -1.0 / 0.0 : 0.0;
                d5 = iftmp$1;
            }
        } else if (Builtins.__finite(d3) == 0) {
            d5 = dnchisq.dnchisq(d * d2, d2, d4, n) * d2;
        } else if (d2 > 1.0E14 && d4 < 1.0E7) {
            double iftmp$2;
            double f = d4 / d2 + 1.0;
            double d6 = 2.0 / d3;
            double d7 = d3 / 2.0;
            double z = dgamma.dgamma(1.0 / d / f, d7, d6, n);
            if (n != 0) {
                double d8 = Math.log(d) * 2.0;
                double d9 = z - d8;
                double d10 = Math.log(f);
                iftmp$2 = d9 - d10;
            } else {
                double d11 = d;
                double d12 = d11 * d11;
                iftmp$2 = z / d12 / f;
            }
            d5 = iftmp$2;
        } else {
            double iftmp$3;
            double y = d2 / d3 * d;
            double d13 = d3 / 2.0;
            double d14 = d2 / 2.0;
            double d15 = y + 1.0;
            double z = dnbeta.dnbeta(y / d15, d14, d13, d4, n);
            if (n != 0) {
                double d16 = Math.log(d2) + z;
                double d17 = Math.log(d3);
                double d18 = d16 - d17;
                double d19 = Mathlib.log1p(y) * 2.0;
                iftmp$3 = d18 - d19;
            } else {
                double d20 = d2 / d3 * z;
                double d21 = y + 1.0;
                double d22 = d20 / d21;
                double d23 = y + 1.0;
                iftmp$3 = d22 / d23;
            }
            d5 = iftmp$3;
        }
        return d5;
    }
}

